/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.login;

import java.io.Serializable;
import javax.inject.Inject;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.errors.ExceptionModel;
import org.apache.isis.viewer.wicket.ui.pages.PageNavigationService;
import org.apache.isis.viewer.wicket.ui.pages.accmngt.AccountManagementPageAbstract;
import org.apache.isis.viewer.wicket.ui.pages.login.IsisSignInPanel;
import org.apache.wicket.Component;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.authroles.authentication.panel.SignInPanel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.cookies.CookieUtils;
import org.apache.wicket.util.string.Strings;

public class WicketSignInPage
extends AccountManagementPageAbstract {
    private static final long serialVersionUID = 1L;
    public static final String ISIS_VIEWER_WICKET_REMEMBER_ME_SUPPRESS = "isis.viewer.wicket.rememberMe.suppress";
    public static final String ISIS_VIEWER_WICKET_SUPPRESS_SIGN_UP = "isis.viewer.wicket.suppressSignUp";
    public static final String ISIS_VIEWER_WICKET_SUPPRESS_PASSWORD_RESET = "isis.viewer.wicket.suppressPasswordReset";
    public static final String ISIS_VIEWER_WICKET_CLEAR_ORIGINAL_DESTINATION = "isis.viewer.wicket.clearOriginalDestination";
    @Inject
    private PageNavigationService pageNavigationService;

    public WicketSignInPage(PageParameters parameters) {
        this(parameters, WicketSignInPage.getAndClearExceptionModelIfAny());
    }

    public WicketSignInPage(PageParameters parameters, ExceptionModel exceptionModel) {
        super(parameters, exceptionModel);
        if (AuthenticatedWebSession.exists() && AuthenticatedWebSession.get().isSignedIn()) {
            this.pageNavigationService.restartAt(PageType.HOME);
        }
    }

    protected void onInitialize() {
        super.onInitialize();
        this.addSignInPanel();
        this.checkForSuccessFeedback();
    }

    private void checkForSuccessFeedback() {
        CookieUtils cookieUtils = new CookieUtils();
        String successFeedback = cookieUtils.load("isis.feedback.success");
        if (!Strings.isEmpty((CharSequence)successFeedback)) {
            this.success((Serializable)((Object)successFeedback));
            cookieUtils.remove("isis.feedback.success");
        }
    }

    protected SignInPanel addSignInPanel() {
        boolean rememberMeSuppress;
        boolean suppressRememberMe = rememberMeSuppress = this.getConfiguration().getBoolean(ISIS_VIEWER_WICKET_REMEMBER_ME_SUPPRESS, false);
        boolean suppressSignUpLink = this.getConfiguration().getBoolean(ISIS_VIEWER_WICKET_SUPPRESS_SIGN_UP, false);
        boolean suppressPasswordResetLink = this.getConfiguration().getBoolean(ISIS_VIEWER_WICKET_SUPPRESS_PASSWORD_RESET, false);
        boolean clearOriginalDestination = this.getConfiguration().getBoolean(ISIS_VIEWER_WICKET_CLEAR_ORIGINAL_DESTINATION, false);
        boolean rememberMe = !suppressRememberMe;
        boolean signUpLink = !suppressSignUpLink;
        boolean passwordReset = !suppressPasswordResetLink;
        boolean continueToOriginalDestination = !clearOriginalDestination;
        SignInPanel signInPanel = this.createSignInPanel("signInPanel", rememberMe, signUpLink, passwordReset, continueToOriginalDestination);
        this.add(new Component[]{signInPanel});
        return signInPanel;
    }

    protected SignInPanel createSignInPanel(String id, boolean rememberMe, boolean signUpLink, boolean passwordResetLink, boolean continueToOriginalDestination) {
        IsisSignInPanel signInPanel = new IsisSignInPanel(id, rememberMe, signUpLink, passwordResetLink, continueToOriginalDestination);
        return signInPanel;
    }
}

