/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.home;

import java.util.Optional;
import java.util.stream.Stream;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facets.actions.homepage.HomePageFacet;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.actions.ActionFormExecutorStrategy;
import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModelProvider;
import org.apache.isis.viewer.wicket.ui.pages.PageAbstract;
import org.apache.isis.viewer.wicket.ui.panels.FormExecutorDefault;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.request.mapper.parameter.PageParameters;

@AuthorizeInstantiation(value={"org.apache.isis.viewer.wicket.roles.USER"})
public class HomePage
extends PageAbstract {
    private static final long serialVersionUID = 1L;

    public HomePage(PageParameters parameters) {
        super(parameters, null, new ComponentType[0]);
        this.addChildComponents(this.themeDiv, null);
        this.buildGui();
        this.addBookmarkedPages(this.themeDiv);
    }

    private void buildGui() {
        ObjectAndAction objectAndAction = this.lookupHomePageAction();
        if (objectAndAction != null) {
            Components.permanentlyHide(this.themeDiv, ComponentType.WELCOME);
            ActionModel actionModel = ActionModel.create((EntityModel)new EntityModel(objectAndAction.objectAdapter), (ObjectAction)objectAndAction.action);
            FormExecutorDefault<ActionModel> formExecutor = new FormExecutorDefault<ActionModel>(new ActionFormExecutorStrategy(actionModel));
            formExecutor.executeAndProcessResults(this.getPage(), null, null, actionModel.isWithinPrompt());
        } else {
            Components.permanentlyHide(this.themeDiv, ComponentType.ACTION_PROMPT);
            this.getComponentFactoryRegistry().addOrReplaceComponent(this.themeDiv, ComponentType.WELCOME, null);
        }
        BreadcrumbModelProvider session = (BreadcrumbModelProvider)this.getSession();
        BreadcrumbModel breadcrumbModel = session.getBreadcrumbModel();
        breadcrumbModel.visitedHomePage();
    }

    private ObjectAndAction lookupHomePageAction() {
        Stream serviceAdapters = this.getPersistenceSession().streamServices();
        return serviceAdapters.map(serviceAdapter -> {
            ObjectSpecification serviceSpec = serviceAdapter.getSpecification();
            Stream objectActions = serviceSpec.streamObjectActions(Contributed.EXCLUDED);
            Optional<ObjectAndAction> homePageAction = objectActions.map(objectAction -> this.objectAndActionIfHomePageAndUsable((ObjectAdapter)serviceAdapter, (ObjectAction)objectAction)).filter(_NullSafe::isPresent).findAny();
            return homePageAction;
        }).filter(Optional::isPresent).map(Optional::get).findAny().orElse(null);
    }

    private ObjectAndAction objectAndActionIfHomePageAndUsable(ObjectAdapter serviceAdapter, ObjectAction objectAction) {
        if (!objectAction.containsDoOpFacet(HomePageFacet.class)) {
            return null;
        }
        Consent visibility = objectAction.isVisible((ManagedObject)serviceAdapter, InteractionInitiatedBy.USER, Where.ANYWHERE);
        if (visibility.isVetoed()) {
            return null;
        }
        Consent usability = objectAction.isUsable((ManagedObject)serviceAdapter, InteractionInitiatedBy.USER, Where.ANYWHERE);
        if (usability.isVetoed()) {
            return null;
        }
        return new ObjectAndAction(serviceAdapter, objectAction);
    }

    private static class ObjectAndAction {
        ObjectAdapter objectAdapter;
        ObjectAction action;

        ObjectAndAction(ObjectAdapter serviceAdapter, ObjectAction objectAction) {
            this.objectAdapter = serviceAdapter;
            this.action = objectAction;
        }
    }
}

