/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.accmngt.password_reset;

import com.google.inject.name.Named;
import java.io.Serializable;
import java.util.HashMap;
import javax.inject.Inject;
import org.apache.isis.applib.services.email.EmailService;
import org.apache.isis.applib.services.userreg.EmailNotificationService;
import org.apache.isis.applib.services.userreg.events.PasswordResetEvent;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.components.widgets.bootstrap.FormGroup;
import org.apache.isis.viewer.wicket.ui.pages.EmailVerificationUrlService;
import org.apache.isis.viewer.wicket.ui.pages.PageNavigationService;
import org.apache.isis.viewer.wicket.ui.pages.accmngt.EmailAvailableValidator;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.util.cookies.CookieUtils;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.EmailAddressValidator;

public class PasswordResetEmailPanel
extends Panel {
    @Inject
    private EmailNotificationService emailNotificationService;
    @Inject
    private EmailService emailService;
    @Inject
    private EmailVerificationUrlService emailVerificationUrlService;
    @Inject
    private PageNavigationService pageNavigationService;
    @Inject
    @Named(value="applicationName")
    private String applicationName;

    public PasswordResetEmailPanel(String id) {
        super(id);
        StatelessForm form = new StatelessForm("signUpForm");
        this.addOrReplace(new Component[]{form});
        final RequiredTextField emailField = new RequiredTextField("email", (IModel)Model.of((Serializable)((Object)"")));
        emailField.setLabel((IModel)new ResourceModel("emailLabel"));
        emailField.add((IValidator)EmailAddressValidator.getInstance());
        emailField.add((IValidator)EmailAvailableValidator.EXISTS);
        FormGroup formGroup = new FormGroup("formGroup", (FormComponent<?>)emailField);
        form.add(new Component[]{formGroup});
        formGroup.add(new Component[]{emailField});
        Button signUpButton = new Button("passwordResetSubmit"){

            public void onSubmit() {
                super.onSubmit();
                String email = (String)emailField.getModelObject();
                String confirmationUrl = PasswordResetEmailPanel.this.emailVerificationUrlService.createVerificationUrl(PageType.PASSWORD_RESET, email);
                PasswordResetEmailPanel.this.emailNotificationService.init();
                PasswordResetEmailPanel.this.emailService.init();
                PasswordResetEvent passwordResetEvent = new PasswordResetEvent(email, confirmationUrl, PasswordResetEmailPanel.this.applicationName);
                boolean emailSent = PasswordResetEmailPanel.this.emailNotificationService.send(passwordResetEvent);
                if (emailSent) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("email", email);
                    IModel model = Model.ofMap(map);
                    String emailSentMessage = this.getString("emailSentMessage", model);
                    CookieUtils cookieUtils = new CookieUtils();
                    cookieUtils.save("isis.feedback.success", emailSentMessage);
                    PasswordResetEmailPanel.this.pageNavigationService.navigateTo(PageType.SIGN_IN);
                }
            }
        };
        form.add(new Component[]{signUpButton});
    }
}

