/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.accmngt;

import org.apache.isis.applib.services.userreg.UserRegistrationService;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;

public class UsernameAvailableValidator
implements IValidator<String> {
    public static final UsernameAvailableValidator INSTANCE = new UsernameAvailableValidator();

    private UsernameAvailableValidator() {
    }

    public void validate(final IValidatable<String> validatable) {
        this.getIsisSessionFactory().doInSession(new Runnable(){

            @Override
            public void run() {
                String username;
                UserRegistrationService userRegistrationService = (UserRegistrationService)UsernameAvailableValidator.this.getServicesInjector().lookupServiceElseFail(UserRegistrationService.class);
                boolean usernameExists = userRegistrationService.usernameExists(username = (String)validatable.getValue());
                if (usernameExists) {
                    validatable.error((IValidationError)new ValidationError().addKey("usernameIsNotAvailable"));
                }
            }
        });
    }

    ServicesInjector getServicesInjector() {
        return this.getIsisSessionFactory().getServicesInjector();
    }

    IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }
}

