/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.accmngt;

import org.apache.isis.applib.services.userreg.UserRegistrationService;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;

public class EmailAvailableValidator
implements IValidator<String> {
    public static final EmailAvailableValidator EXISTS = new EmailAvailableValidator(true, "noSuchUserByEmail");
    public static final EmailAvailableValidator DOESNT_EXIST = new EmailAvailableValidator(false, "emailIsNotAvailable");
    private final boolean emailExists;
    private final String resourceKey;

    private EmailAvailableValidator(boolean emailExists, String resourceKey) {
        this.emailExists = emailExists;
        this.resourceKey = resourceKey;
    }

    public void validate(final IValidatable<String> validatable) {
        this.getIsisSessionFactory().doInSession(new Runnable(){

            @Override
            public void run() {
                String email;
                UserRegistrationService userRegistrationService = (UserRegistrationService)EmailAvailableValidator.this.getServicesInjector().lookupServiceElseFail(UserRegistrationService.class);
                boolean emailExists1 = userRegistrationService.emailExists(email = (String)validatable.getValue());
                if (emailExists1 != EmailAvailableValidator.this.emailExists) {
                    validatable.error((IValidationError)new ValidationError().addKey(EmailAvailableValidator.this.resourceKey));
                }
            }
        });
    }

    ServicesInjector getServicesInjector() {
        return this.getIsisSessionFactory().getServicesInjector();
    }

    IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }
}

