/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.accmngt;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapJavascriptBehavior;
import de.agilecoders.wicket.core.markup.html.references.BootstrapJavaScriptReference;
import java.io.Serializable;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.components.widgets.navbar.BrandLogo;
import org.apache.isis.viewer.wicket.ui.components.widgets.navbar.BrandName;
import org.apache.isis.viewer.wicket.ui.components.widgets.navbar.Placement;
import org.apache.isis.viewer.wicket.ui.errors.ExceptionModel;
import org.apache.isis.viewer.wicket.ui.errors.ExceptionStackTracePanel;
import org.apache.isis.viewer.wicket.ui.pages.PageAbstract;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.markup.head.filter.HeaderResponseContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;

public class AccountManagementPageAbstract
extends WebPage {
    private static final long serialVersionUID = 1L;
    private static final String ID_PAGE_TITLE = "pageTitle";
    private static final String ID_APPLICATION_NAME = "applicationName";
    private static final String ID_EXCEPTION_STACK_TRACE = "exceptionStackTrace";
    public static final String FEEDBACK_COOKIE_NAME = "isis.feedback.success";
    @Inject
    @Named(value="applicationName")
    private String applicationName;
    @Inject
    @Named(value="applicationCss")
    private String applicationCss;
    @Inject
    @Named(value="applicationJs")
    private String applicationJs;
    @javax.inject.Inject
    private PageClassRegistry pageClassRegistry;

    protected static ExceptionModel getAndClearExceptionModelIfAny() {
        ExceptionModel exceptionModel = PageAbstract.EXCEPTION.get();
        PageAbstract.EXCEPTION.remove();
        return exceptionModel;
    }

    protected AccountManagementPageAbstract(PageParameters parameters, ExceptionModel exceptionModel) {
        super(parameters);
        Class<? extends Page> pageClass = this.pageClassRegistry.getPageClass(PageType.SIGN_IN);
        BookmarkablePageLink signInLink = new BookmarkablePageLink("signInLink", pageClass);
        signInLink.setAutoEnable(true);
        this.add(new Component[]{signInLink});
        this.addPageTitle();
        this.addApplicationName((MarkupContainer)signInLink);
        if (exceptionModel != null) {
            this.add(new Component[]{new ExceptionStackTracePanel(ID_EXCEPTION_STACK_TRACE, exceptionModel)});
        } else {
            this.add(new Component[]{new WebMarkupContainer(ID_EXCEPTION_STACK_TRACE).setVisible(false)});
        }
        this.add(new Component[]{new HeaderResponseContainer("footerJS", "footerJS")});
        BootstrapJavascriptBehavior.addTo((Component)this);
    }

    private MarkupContainer addPageTitle() {
        return this.add(new Component[]{new Label(ID_PAGE_TITLE, (Serializable)((Object)this.applicationName))});
    }

    private void addApplicationName(MarkupContainer parent) {
        Placement placement = Placement.SIGNIN;
        BrandLogo brandLogo = new BrandLogo("brandLogo", placement);
        BrandName brandName = new BrandName(ID_APPLICATION_NAME, placement);
        parent.add(new Component[]{brandName, brandLogo});
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)Application.get().getJavaScriptLibrarySettings().getJQueryReference())));
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)BootstrapJavaScriptReference.instance())));
        if (this.applicationCss != null) {
            response.render((HeaderItem)CssReferenceHeaderItem.forUrl((String)this.applicationCss));
        }
        if (this.applicationJs != null) {
            response.render((HeaderItem)JavaScriptReferenceHeaderItem.forUrl((String)this.applicationJs));
        }
    }

    protected IsisConfiguration getConfiguration() {
        return this.getIsisSessionFactory().getConfiguration();
    }

    protected IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }
}

