/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers.ObjectAdapterMementoProviderAbstract;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers.ObjectAdapterMementoProviderForChoices;

public class ObjectAdapterMementoProviderForReferenceChoices
extends ObjectAdapterMementoProviderAbstract
implements ObjectAdapterMementoProviderForChoices {
    private static final long serialVersionUID = 1L;
    private final List<ObjectAdapterMemento> choiceMementos;

    public ObjectAdapterMementoProviderForReferenceChoices(ScalarModel model, WicketViewerSettings wicketViewerSettings, List<ObjectAdapterMemento> choiceMementos) {
        super(model, wicketViewerSettings);
        this.choiceMementos = choiceMementos;
    }

    @Override
    protected List<ObjectAdapterMemento> obtainMementos(String term) {
        return this.obtainMementos(term, this.choiceMementos);
    }

    @Override
    public List<ObjectAdapterMemento> getChoiceMementos() {
        return this.choiceMementos;
    }

    public Collection<ObjectAdapterMemento> toChoices(Collection<String> ids) {
        Function<String, ObjectAdapterMemento> function = input -> {
            if ("$$_isis_null_$$".equals(input)) {
                return null;
            }
            RootOid oid = RootOid.deString((String)input);
            return ObjectAdapterMemento.createPersistent((RootOid)oid);
        };
        return _NullSafe.stream(ids).map(function).collect(Collectors.toList());
    }
}

