/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.tree;

import java.io.Serializable;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelTextFieldParseableAbstract;
import org.apache.isis.viewer.wicket.ui.components.tree.IsisToWicketTreeAdapter;
import org.apache.isis.viewer.wicket.ui.components.widgets.bootstrap.FormGroup;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class TreePanel
extends ScalarPanelTextFieldParseableAbstract {
    private static final long serialVersionUID = 1L;

    public TreePanel(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
    }

    @Override
    protected String getScalarPanelType() {
        return "treePanel";
    }

    @Override
    protected MarkupContainer createScalarIfRegularFormGroup() {
        if (((ScalarModel)this.getModel()).isEditMode()) {
            return super.createScalarIfRegularFormGroup();
        }
        Component treeComponent = this.createTreeComponent("scalarValueContainer");
        this.getTextField().setLabel((IModel)Model.of((Serializable)((Object)((ScalarModel)this.getModel()).getName())));
        FormGroup formGroup = new FormGroup("scalarIfRegular", (FormComponent<?>)this.getTextField());
        formGroup.add(new Component[]{treeComponent});
        String labelCaption = this.getRendering().getLabelCaption((LabeledWebMarkupContainer)this.getTextField());
        Label scalarName = this.createScalarName("scalarName", labelCaption);
        formGroup.add(new Component[]{scalarName});
        return formGroup;
    }

    @Override
    protected Component createComponentForCompact() {
        return this.createTreeComponent("scalarIfCompact");
    }

    private Component createTreeComponent(String id) {
        return IsisToWicketTreeAdapter.adapt(id, (ScalarModel)this.getModel());
    }
}

