/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.standalonecollection;

import java.io.Serializable;
import java.util.List;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.components.collection.count.CollectionCountProvider;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorHelper;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorPanel;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorProvider;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class StandaloneCollectionPanel
extends PanelAbstract<EntityCollectionModel>
implements CollectionCountProvider,
CollectionSelectorProvider {
    private static final long serialVersionUID = 1L;
    private static final String ID_STANDALONE_COLLECTION = "standaloneCollection";
    private static final String ID_ACTION_NAME = "actionName";
    private static final String ID_SELECTOR_DROPDOWN = "selectorDropdown";
    private final CollectionSelectorPanel selectorDropdownPanel;
    private MarkupContainer outerDiv = new WebMarkupContainer("standaloneCollection");

    public StandaloneCollectionPanel(String id, EntityCollectionModel entityCollectionModel) {
        super(id, entityCollectionModel);
        this.addOrReplace(new Component[]{this.outerDiv});
        ActionModel actionModel = entityCollectionModel.getActionModelHint();
        ObjectAction action = actionModel.getActionMemento().getAction(entityCollectionModel.getSpecificationLoader());
        this.outerDiv.addOrReplace(new Component[]{new Label(ID_ACTION_NAME, (IModel)Model.of((Serializable)((Object)action.getName())))});
        CssClassAppender.appendCssClassTo(this.outerDiv, CssClassAppender.asCssStyle("isis-" + action.getOnType().getSpecId().asString().replace('.', '-') + "-" + action.getId()));
        CssClassAppender.appendCssClassTo(this.outerDiv, CssClassAppender.asCssStyle("isis-" + entityCollectionModel.getTypeOfSpecification().getSpecId().asString().replace('.', '-')));
        CollectionSelectorHelper selectorHelper = new CollectionSelectorHelper(entityCollectionModel, this.getComponentFactoryRegistry());
        List<ComponentFactory> componentFactories = selectorHelper.getComponentFactories();
        if (componentFactories.size() <= 1) {
            Components.permanentlyHide(this.outerDiv, ID_SELECTOR_DROPDOWN);
            this.selectorDropdownPanel = null;
        } else {
            CollectionSelectorPanel selectorDropdownPanel = new CollectionSelectorPanel(ID_SELECTOR_DROPDOWN, entityCollectionModel);
            Model componentFactoryModel = new Model();
            String selected = selectorHelper.honourViewHintElseDefault((Component)selectorDropdownPanel);
            ComponentFactory selectedComponentFactory = selectorHelper.find(selected);
            componentFactoryModel.setObject((Serializable)selectedComponentFactory);
            this.outerDiv.setOutputMarkupId(true);
            this.outerDiv.addOrReplace(new Component[]{selectorDropdownPanel});
            this.selectorDropdownPanel = selectorDropdownPanel;
        }
        ComponentFactoryRegistry componentFactoryRegistry = this.getComponentFactoryRegistry();
        componentFactoryRegistry.addOrReplaceComponent(this.outerDiv, ComponentType.COLLECTION_CONTENTS, (IModel<?>)entityCollectionModel);
    }

    @Override
    public CollectionSelectorPanel getSelectorDropdownPanel() {
        return this.selectorDropdownPanel;
    }

    @Override
    public Integer getCount() {
        EntityCollectionModel model = (EntityCollectionModel)this.getModel();
        return model.getCount();
    }
}

