/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.markup;

import org.apache.isis.applib.value.Markup;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.model.IModel;

public class MarkupComponent
extends WebComponent {
    private static final long serialVersionUID = 1L;

    public MarkupComponent(String id, IModel<?> model) {
        super(id, model);
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        this.replaceComponentTagBody(markupStream, openTag, this.extractHtmlOrElse(this.getDefaultModelObject(), ""));
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.setType(XmlTag.TagType.OPEN);
    }

    private CharSequence extractHtmlOrElse(Object modelObject, String fallback) {
        if (modelObject == null) {
            return fallback;
        }
        if (modelObject instanceof ObjectAdapter) {
            ObjectAdapter objAdapter = (ObjectAdapter)modelObject;
            if (objAdapter.getPojo() == null) {
                return fallback;
            }
            Object value = objAdapter.getPojo();
            if (!(value instanceof Markup)) {
                return fallback;
            }
            return ((Markup)value).asString();
        }
        return modelObject.toString();
    }
}

