/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.jdk8time;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.ui.components.scalars.DateFormatSettings;
import org.apache.isis.viewer.wicket.ui.components.scalars.jdk8time.DateConverterForJdk8Abstract;
import org.apache.wicket.util.convert.ConversionException;

public class DateConverterForJdk8OffsetDateTime
extends DateConverterForJdk8Abstract<OffsetDateTime> {
    private static final long serialVersionUID = 1L;

    public DateConverterForJdk8OffsetDateTime(WicketViewerSettings settings, int adjustBy) {
        super(OffsetDateTime.class, DateFormatSettings.ofDateAndTime(settings, adjustBy));
    }

    @Override
    protected OffsetDateTime minusDays(OffsetDateTime value, int adjustBy) {
        return value.minusDays(adjustBy);
    }

    @Override
    protected OffsetDateTime plusDays(OffsetDateTime value, int adjustBy) {
        return value.plusDays(adjustBy);
    }

    @Override
    protected OffsetDateTime convert(String value) throws ConversionException {
        return OffsetDateTime.of(this.convertToLocal(value), this.defaultOffset());
    }

    @Override
    protected String toString(OffsetDateTime value, DateTimeFormatter dateTimeFormatter) {
        return value.format(dateTimeFormatter);
    }

    private LocalDateTime convertToLocal(String value) throws ConversionException {
        try {
            return this.getFormatterForDateTimePattern8().parse((CharSequence)value, LocalDateTime::from);
        }
        catch (Exception ex) {
            try {
                return LocalDateTime.of(this.getFormatterForDatePattern8().parse((CharSequence)value, LocalDate::from), LocalTime.of(0, 0));
            }
            catch (Exception ex2) {
                throw new ConversionException(String.format("Cannot convert '%s' into a date/time using pattern '%s' or '%s'", value, this.dateFormatSettings.getDateTimePattern(), this.dateFormatSettings.getDatePattern()), (Throwable)ex2);
            }
        }
    }

    private ZoneOffset defaultOffset() {
        return OffsetDateTime.now().getOffset();
    }
}

