/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.context._Plugin;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.objectvalue.renderedadjusted.RenderedAdjustedFacet;
import org.apache.isis.core.metamodel.facets.value.bigdecimal.BigDecimalValueFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.ui.components.scalars.DateConverter;
import org.apache.isis.viewer.wicket.ui.components.scalars.DateConverterPlugin;
import org.apache.isis.viewer.wicket.ui.components.scalars.jdkdates.DateConverterForJavaSqlDate;
import org.apache.isis.viewer.wicket.ui.components.scalars.jdkdates.DateConverterForJavaSqlTimestamp;
import org.apache.isis.viewer.wicket.ui.components.scalars.jdkdates.DateConverterForJavaUtilDate;
import org.apache.isis.viewer.wicket.ui.components.scalars.jdkmath.BigDecimalConverterWithScale;
import org.apache.isis.viewer.wicket.ui.components.scalars.jodatime.DateConverterForJodaDateTime;
import org.apache.isis.viewer.wicket.ui.components.scalars.jodatime.DateConverterForJodaLocalDate;
import org.apache.isis.viewer.wicket.ui.components.scalars.jodatime.DateConverterForJodaLocalDateTime;
import org.apache.wicket.Application;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.BigIntegerConverter;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class IsisConverterLocator {
    public static IConverter<Object> findConverter(ObjectAdapter objectAdapter, WicketViewerSettings wicketViewerSettings) {
        int adjustBy;
        ObjectSpecification objectSpecification = objectAdapter.getSpecification();
        if (!objectSpecification.isValue()) {
            return null;
        }
        Class correspondingClass = objectSpecification.getCorrespondingClass();
        if (Enum.class.isAssignableFrom(correspondingClass)) {
            return null;
        }
        RenderedAdjustedFacet renderedAdjustedFacet = (RenderedAdjustedFacet)objectSpecification.getFacet(RenderedAdjustedFacet.class);
        int n = adjustBy = renderedAdjustedFacet != null ? renderedAdjustedFacet.value() : 0;
        if (java.util.Date.class == correspondingClass) {
            return (IConverter)_Casts.uncheckedCast((Object)new DateConverterForJavaUtilDate(wicketViewerSettings, adjustBy));
        }
        if (Date.class == correspondingClass) {
            return (IConverter)_Casts.uncheckedCast((Object)new DateConverterForJavaSqlDate(wicketViewerSettings, adjustBy));
        }
        if (LocalDate.class == correspondingClass) {
            return (IConverter)_Casts.uncheckedCast((Object)new DateConverterForJodaLocalDate(wicketViewerSettings, adjustBy));
        }
        if (LocalDateTime.class == correspondingClass) {
            return (IConverter)_Casts.uncheckedCast((Object)new DateConverterForJodaLocalDateTime(wicketViewerSettings, adjustBy));
        }
        if (DateTime.class == correspondingClass) {
            return (IConverter)_Casts.uncheckedCast((Object)new DateConverterForJodaDateTime(wicketViewerSettings, adjustBy));
        }
        if (Timestamp.class == correspondingClass) {
            return (IConverter)_Casts.uncheckedCast((Object)new DateConverterForJavaSqlTimestamp(wicketViewerSettings, adjustBy));
        }
        DateConverter converter = _Plugin.loadAll(DateConverterPlugin.class).stream().map(plugin -> plugin.converterForClassIfAny(correspondingClass, wicketViewerSettings, adjustBy)).filter(_NullSafe::isPresent).findAny().orElse(null);
        if (converter != null) {
            return (IConverter)_Casts.uncheckedCast((Object)converter);
        }
        if (BigInteger.class == correspondingClass) {
            return (IConverter)_Casts.uncheckedCast((Object)new BigIntegerConverter());
        }
        if (BigDecimal.class == correspondingClass) {
            BigDecimalValueFacet facet = (BigDecimalValueFacet)objectSpecification.getFacet(BigDecimalValueFacet.class);
            Integer scale = null;
            if (facet != null) {
                scale = facet.getScale();
            }
            return (IConverter)_Casts.uncheckedCast(new BigDecimalConverterWithScale(scale).forViewMode());
        }
        if (Application.exists()) {
            IConverterLocator converterLocator = Application.get().getConverterLocator();
            return (IConverter)_Casts.uncheckedCast((Object)converterLocator.getConverter(correspondingClass));
        }
        return null;
    }
}

