/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.property;

import java.util.concurrent.Callable;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.concurrency.ConcurrencyChecking;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.pages.entity.EntityPage;
import org.apache.isis.viewer.wicket.ui.panels.FormExecutorStrategy;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;

public class PropertyFormExecutorStrategy
implements FormExecutorStrategy<ScalarModel> {
    private final ScalarModel model;

    public PropertyFormExecutorStrategy(ScalarModel scalarModel) {
        this.model = scalarModel;
    }

    @Override
    public ScalarModel getModel() {
        return this.model;
    }

    @Override
    public ObjectAdapter obtainTargetAdapter() {
        return this.model.getParentEntityModel().load();
    }

    @Override
    public String getReasonInvalidIfAny() {
        return this.model.getReasonInvalidIfAny();
    }

    @Override
    public void onExecuteAndProcessResults(AjaxRequestTarget target) {
    }

    @Override
    public ObjectAdapter obtainResultAdapter() {
        ObjectAdapter targetAdapter = this.obtainTargetAdapter();
        ObjectAdapter resultAdapter = this.model.applyValue(targetAdapter);
        if (resultAdapter != targetAdapter) {
            this.model.getParentEntityModel().setObject(targetAdapter);
        }
        return resultAdapter;
    }

    @Override
    public void redirectTo(final ObjectAdapter resultAdapter, AjaxRequestTarget target) {
        EntityPage entityPage = (EntityPage)((Object)ConcurrencyChecking.executeWithConcurrencyCheckingDisabled((Callable)new Callable<EntityPage>(){

            @Override
            public EntityPage call() throws Exception {
                return new EntityPage(resultAdapter, null);
            }
        }));
        RequestCycle requestCycle = RequestCycle.get();
        requestCycle.setResponsePage((IRequestablePage)entityPage);
    }
}

