/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.layout.bs3.col;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.isis.applib.layout.component.CollectionLayoutData;
import org.apache.isis.applib.layout.component.DomainObjectLayoutData;
import org.apache.isis.applib.layout.component.FieldSet;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Col;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3ElementAbstract;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Row;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Tab;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3TabGroup;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.AdditionalLinksPanel;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.LinkAndLabelUtil;
import org.apache.isis.viewer.wicket.ui.components.entity.fieldset.PropertyGroup;
import org.apache.isis.viewer.wicket.ui.components.layout.bs3.Util;
import org.apache.isis.viewer.wicket.ui.components.layout.bs3.col.RepeatingViewWithDynamicallyVisibleContent;
import org.apache.isis.viewer.wicket.ui.components.layout.bs3.row.Row;
import org.apache.isis.viewer.wicket.ui.components.layout.bs3.tabs.TabGroupPanel;
import org.apache.isis.viewer.wicket.ui.panels.HasDynamicallyVisibleContent;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

public class Col
extends PanelAbstract<EntityModel>
implements HasDynamicallyVisibleContent {
    private static final long serialVersionUID = 1L;
    private static final String ID_COL = "col";
    private static final String ID_ENTITY_HEADER_PANEL = "entityHeaderPanel";
    private static final String ID_ROWS = "rows";
    private static final String ID_TAB_GROUPS = "tabGroups";
    private static final String ID_FIELD_SETS = "fieldSets";
    private static final String ID_COLLECTIONS = "collections";
    private final BS3Col bs3Col;
    private boolean visible = false;

    public Col(String id, EntityModel entityModel, BS3Col bs3Col) {
        super(id, entityModel);
        this.bs3Col = bs3Col;
        this.buildGui();
    }

    private void buildGui() {
        ArrayList rows;
        String actionIdToHide;
        String actionIdToUse;
        WebMarkupContainer actionOwner;
        this.setRenderBodyOnly(true);
        if (this.bs3Col.getSpan() == 0) {
            Components.permanentlyHide((MarkupContainer)this, ID_COL);
            return;
        }
        WebMarkupContainer div = new WebMarkupContainer(ID_COL);
        CssClassAppender.appendCssClassTo((MarkupContainer)div, this.bs3Col.toCssClass());
        Util.appendCssClass((MarkupContainer)div, (BS3ElementAbstract)this.bs3Col, ID_COL);
        DomainObjectLayoutData domainObject = this.bs3Col.getDomainObject();
        if (domainObject != null) {
            WebMarkupContainer entityHeaderPanel = new WebMarkupContainer(ID_ENTITY_HEADER_PANEL);
            div.add(new Component[]{entityHeaderPanel});
            ComponentFactory componentFactory = this.getComponentFactoryRegistry().findComponentFactory(ComponentType.ENTITY_ICON_TITLE_AND_COPYLINK, (IModel<?>)this.getModel());
            Component component = componentFactory.createComponent((IModel<?>)this.getModel());
            entityHeaderPanel.addOrReplace(new Component[]{component});
            actionOwner = entityHeaderPanel;
            actionIdToUse = "entityActions";
            actionIdToHide = "actions";
            this.visible = true;
        } else {
            Components.permanentlyHide((MarkupContainer)div, ID_ENTITY_HEADER_PANEL);
            actionOwner = div;
            actionIdToUse = "actions";
            actionIdToHide = null;
        }
        List actionLayoutDatas = this.bs3Col.getActions();
        List visibleActions = _Lists.transform((Collection)actionLayoutDatas, stream -> stream.filter(actionLayoutData -> actionLayoutData.getMetadataError() == null).map(actionLayoutData -> ((EntityModel)this.getModel()).getTypeOfSpecification().getObjectAction(actionLayoutData.getId())).filter(_NullSafe::isPresent));
        List<LinkAndLabel> entityActionLinks = LinkAndLabelUtil.asActionLinksForAdditionalLinksPanel((EntityModel)this.getModel(), visibleActions, null);
        if (!entityActionLinks.isEmpty()) {
            AdditionalLinksPanel.addAdditionalLinks((MarkupContainer)actionOwner, actionIdToUse, entityActionLinks, AdditionalLinksPanel.Style.INLINE_LIST);
            this.visible = true;
        } else {
            Components.permanentlyHide((MarkupContainer)actionOwner, actionIdToUse);
        }
        if (actionIdToHide != null) {
            Components.permanentlyHide((MarkupContainer)div, actionIdToHide);
        }
        if (!(rows = _Lists.newArrayList((Collection)this.bs3Col.getRows())).isEmpty()) {
            RepeatingViewWithDynamicallyVisibleContent rowsRv = this.buildRows(ID_ROWS, rows);
            div.add(new Component[]{rowsRv});
            this.visible = this.visible || rowsRv.isVisible();
        } else {
            Components.permanentlyHide((MarkupContainer)div, ID_ROWS);
        }
        ImmutableList tabGroupsWithNonEmptyTabs = FluentIterable.from((Iterable)this.bs3Col.getTabGroups()).filter((Predicate)new Predicate<BS3TabGroup>(){

            public boolean apply(@Nullable BS3TabGroup bs3TabGroup) {
                List bs3TabsWithRows = _NullSafe.stream((Collection)bs3TabGroup.getTabs()).filter(BS3Tab.Predicates.notEmpty()).collect(Collectors.toList());
                return !bs3TabsWithRows.isEmpty();
            }
        }).toList();
        if (!tabGroupsWithNonEmptyTabs.isEmpty()) {
            RepeatingViewWithDynamicallyVisibleContent tabGroupRv = new RepeatingViewWithDynamicallyVisibleContent(ID_TAB_GROUPS);
            block4: for (Object bs3TabGroup : tabGroupsWithNonEmptyTabs) {
                String id = tabGroupRv.newChildId();
                List tabs = _NullSafe.stream((Collection)bs3TabGroup.getTabs()).filter(BS3Tab.Predicates.notEmpty()).collect(Collectors.toList());
                switch (tabs.size()) {
                    case 0: {
                        throw new IllegalStateException("Cannot render tabGroup with no tabs");
                    }
                    case 1: {
                        if (bs3TabGroup.isCollapseIfOne() != null && !bs3TabGroup.isCollapseIfOne().booleanValue()) break;
                        BS3Tab bs3Tab = (BS3Tab)tabs.get(0);
                        List tabRows = bs3Tab.getRows();
                        RepeatingViewWithDynamicallyVisibleContent rowsRv = this.buildRows(id, tabRows);
                        tabGroupRv.add(new Component[]{rowsRv});
                        continue block4;
                    }
                }
                TabGroupPanel tabGroup = new TabGroupPanel(id, (EntityModel)this.getModel(), (BS3TabGroup)bs3TabGroup);
                tabGroupRv.add(new Component[]{tabGroup});
            }
            div.add(new Component[]{tabGroupRv});
            this.visible = this.visible || tabGroupRv.isVisible();
        } else {
            Components.permanentlyHide((MarkupContainer)div, ID_TAB_GROUPS);
        }
        ImmutableList fieldSetsWithProperties = FluentIterable.from((Iterable)this.bs3Col.getFieldSets()).filter((Predicate)new Predicate<FieldSet>(){

            public boolean apply(@Nullable FieldSet fieldSet) {
                return !fieldSet.getProperties().isEmpty();
            }
        }).toList();
        if (!fieldSetsWithProperties.isEmpty()) {
            RepeatingViewWithDynamicallyVisibleContent fieldSetRv = new RepeatingViewWithDynamicallyVisibleContent(ID_FIELD_SETS);
            for (FieldSet fieldSet : fieldSetsWithProperties) {
                String id = fieldSetRv.newChildId();
                PropertyGroup propertyGroup = new PropertyGroup(id, (EntityModel)this.getModel(), fieldSet);
                fieldSetRv.add(new Component[]{propertyGroup});
            }
            div.add(new Component[]{fieldSetRv});
            this.visible = this.visible || fieldSetRv.isVisible();
        } else {
            Components.permanentlyHide((MarkupContainer)div, ID_FIELD_SETS);
        }
        ImmutableList collections = FluentIterable.from((Iterable)this.bs3Col.getCollections()).filter((Predicate)new Predicate<CollectionLayoutData>(){

            public boolean apply(CollectionLayoutData collectionLayoutData) {
                return collectionLayoutData.getMetadataError() == null;
            }
        }).toList();
        if (!collections.isEmpty()) {
            RepeatingViewWithDynamicallyVisibleContent collectionRv = new RepeatingViewWithDynamicallyVisibleContent(ID_COLLECTIONS);
            EntityModel entityModel = (EntityModel)this.getModel();
            CollectionLayoutData snapshot = entityModel.getCollectionLayoutData();
            for (CollectionLayoutData collection : collections) {
                String id = collectionRv.newChildId();
                entityModel.setCollectionLayoutData(collection);
                ComponentFactory componentFactory = this.getComponentFactoryRegistry().findComponentFactory(ComponentType.ENTITY_COLLECTION, (IModel<?>)entityModel);
                Component collectionPanel = componentFactory.createComponent(id, (IModel<?>)entityModel);
                collectionRv.add(collectionPanel);
            }
            div.add(new Component[]{collectionRv});
            this.visible = this.visible || collectionRv.isVisible();
            entityModel.setCollectionLayoutData(snapshot);
        } else {
            Components.permanentlyHide((MarkupContainer)div, ID_COLLECTIONS);
        }
        Col panel = this;
        if (this.visible) {
            panel.add(new Component[]{div});
        } else {
            Components.permanentlyHide((MarkupContainer)panel, div.getId());
        }
    }

    private RepeatingViewWithDynamicallyVisibleContent buildRows(String owningId, List<BS3Row> rows) {
        RepeatingViewWithDynamicallyVisibleContent rowRv = new RepeatingViewWithDynamicallyVisibleContent(owningId);
        for (BS3Row bs3Row : rows) {
            String id = rowRv.newChildId();
            Row row = new Row(id, (EntityModel)this.getModel(), bs3Row);
            rowRv.add(new Component[]{row});
        }
        return rowRv;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }
}

