/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.footer;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.Serializable;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.viewer.wicket.ui.components.footer.CreditImage;
import org.apache.isis.viewer.wicket.ui.components.footer.CreditName;
import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbPanel;
import org.apache.isis.viewer.wicket.ui.components.widgets.themepicker.ThemeChooser;
import org.apache.isis.viewer.wicket.ui.pages.about.AboutPage;
import org.apache.isis.viewer.wicket.ui.pages.home.HomePage;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class FooterPanel
extends PanelAbstract<Model<String>> {
    private static final long serialVersionUID = 1L;
    private static final String ID_BREADCRUMBS = "breadcrumbs";
    private static final String ID_ABOUT_LINK = "aboutLink";
    private static final String ID_ABOUT_MESSAGE = "aboutMessage";
    private static final String ID_THEME_PICKER = "themePicker";
    @Inject
    @Named(value="applicationVersion")
    private String applicationVersion;

    public FooterPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.addBreadcrumbs();
        this.addCredits();
        this.addAboutLink();
        this.addThemePicker();
    }

    private void addCredits() {
        boolean credits = false;
        credits = this.addCredit(1) || credits;
        credits = this.addCredit(2) || credits;
        credits = this.addCredit(3) || credits;
        Label creditsLabel = new Label("creditsLabel", (Serializable)((Object)"Credits: "));
        this.add(new Component[]{creditsLabel});
        creditsLabel.setVisibilityAllowed(credits);
    }

    private boolean addCredit(int num) {
        Credit credit = Credit.create(this.getConfiguration(), num);
        WebMarkupContainer creditLink = this.newLink(credit);
        if (credit.isDefined()) {
            creditLink.add(new Component[]{new CreditImage(credit.getImageId(), credit.getImage())});
            creditLink.add(new Component[]{new CreditName(credit.getNameId(), credit.getName())});
            this.add(new Component[]{creditLink});
        } else {
            Components.permanentlyHide((MarkupContainer)this, credit.getId());
        }
        return credit.isDefined();
    }

    private WebMarkupContainer newLink(Credit credit) {
        String url = credit.getUrl();
        String creditId = credit.getId();
        Object creditLink = url != null ? new ExternalLink(creditId, url){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("target", (CharSequence)"_blank");
            }
        } : new BookmarkablePageLink(creditId, HomePage.class);
        return creditLink;
    }

    private void addBreadcrumbs() {
        boolean showBreadcrumbs = this.getConfiguration().getBoolean("isis.viewer.wicket.breadcrumbs.showChooser", true);
        BreadcrumbPanel breadcrumbPanel = showBreadcrumbs ? new BreadcrumbPanel(ID_BREADCRUMBS) : new EmptyPanel(ID_BREADCRUMBS).setVisible(false);
        this.addOrReplace(new Component[]{breadcrumbPanel});
    }

    protected void onConfigure() {
        super.onConfigure();
        boolean showFooter = this.getConfiguration().getBoolean("isis.viewer.wicket.showFooter", true);
        if (!showFooter) {
            this.setVisible(false);
            return;
        }
        PageParameters parameters = this.getPage().getPageParameters();
        this.setVisible(parameters.get("isis.no.footer").isNull());
    }

    private void addAboutLink() {
        BookmarkablePageLink aboutLink = new BookmarkablePageLink(ID_ABOUT_LINK, AboutPage.class);
        this.add(new Component[]{aboutLink});
        Label aboutLabel = this.applicationVersion != null && !this.applicationVersion.isEmpty() ? new Label(ID_ABOUT_MESSAGE, (Serializable)((Object)this.applicationVersion)) : new Label(ID_ABOUT_MESSAGE, (IModel)new ResourceModel("aboutLabel"));
        aboutLink.add(new Component[]{aboutLabel});
        this.addDevModeWarning((MarkupContainer)aboutLink);
    }

    private void addDevModeWarning(MarkupContainer container) {
        WebComponent devModeWarning = new WebComponent("devModeWarning");
        devModeWarning.setVisible(this.getApplication().usesDevelopmentConfig());
        container.add(new Component[]{devModeWarning});
    }

    private void addThemePicker() {
        ThemeChooser themeChooser = new ThemeChooser(ID_THEME_PICKER);
        this.addOrReplace(new Component[]{themeChooser});
    }

    static class Credit {
        private final int num;
        private final String url;
        private final String name;
        private final String image;
        final boolean defined;

        private Credit(int num, String url, String name, String image) {
            this.num = num;
            this.url = url;
            this.name = name;
            this.image = image;
            this.defined = (name != null || image != null) && url != null;
        }

        int getNum() {
            return this.num;
        }

        boolean isDefined() {
            return this.defined;
        }

        String getId() {
            return this.idFor("");
        }

        String getUrl() {
            return this.url;
        }

        String getUrlId() {
            return this.idFor("Url");
        }

        String getName() {
            return this.name;
        }

        String getNameId() {
            return this.idFor("Name");
        }

        String getImage() {
            return this.image;
        }

        String getImageId() {
            return this.idFor("Image");
        }

        private String idFor(String component) {
            return "credit" + this.num + component;
        }

        public static Credit create(IsisConfiguration configuration, int num) {
            String base = "isis.viewer.wicket.credit." + num + ".";
            String url = configuration.getString(base + "url");
            String name = configuration.getString(base + "name");
            String image = configuration.getString(base + "image");
            return new Credit(num, url, name, image);
        }
    }
}

