/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions;

import java.util.Collections;
import java.util.List;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.concurrency.ConcurrencyChecking;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.model.models.ToggledMementosProvider;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.EntityActionLinkFactory;

public final class LinkAndLabelUtil {
    private LinkAndLabelUtil() {
    }

    public static List<LinkAndLabel> asActionLinksForAssociation(ScalarModel scalarModelForAssociation) {
        if (scalarModelForAssociation.getKind() != ScalarModel.Kind.PROPERTY) {
            return Collections.emptyList();
        }
        EntityModel parentEntityModel = scalarModelForAssociation.getParentEntityModel();
        ObjectAdapter parentAdapter = parentEntityModel.load(ConcurrencyChecking.NO_CHECK);
        OneToOneAssociation oneToOneAssociation = scalarModelForAssociation.getPropertyMemento().getProperty(scalarModelForAssociation.getSpecificationLoader());
        List associatedActions = ObjectAction.Util.findForAssociation((ObjectAdapter)parentAdapter, (ObjectAssociation)oneToOneAssociation);
        return LinkAndLabelUtil.asActionLinksForAdditionalLinksPanel(parentEntityModel, associatedActions, scalarModelForAssociation);
    }

    public static List<LinkAndLabel> asActionLinksForAdditionalLinksPanel(EntityModel parentEntityModel, List<ObjectAction> objectActions, ScalarModel scalarModelForAssociationIfAny) {
        return LinkAndLabelUtil.asActionLinksForAdditionalLinksPanel(parentEntityModel, objectActions, scalarModelForAssociationIfAny, null);
    }

    public static List<LinkAndLabel> asActionLinksForAdditionalLinksPanel(EntityModel parentEntityModel, List<ObjectAction> objectActions, ScalarModel scalarModelForAssociationIfAny, ToggledMementosProvider toggledMementosProviderIfAny) {
        EntityActionLinkFactory linkFactory = new EntityActionLinkFactory(parentEntityModel, scalarModelForAssociationIfAny);
        return _Lists.transform(objectActions, stream -> stream.map(objectAction -> linkFactory.newLink((ObjectAction)objectAction, "additionalLink", toggledMementosProviderIfAny)).filter(_NullSafe::isPresent));
    }
}

