/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.util;

import java.io.Serializable;
import javax.inject.Provider;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.hint.HintStore;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.wicket.Component;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class ComponentHintKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Provider<Component> componentProvider;
    private Component component;
    private final String keyName;
    private final String fullKey;

    public static ComponentHintKey create(Provider<Component> pathProvider, String key) {
        return new ComponentHintKey(pathProvider, null, key, null);
    }

    public static ComponentHintKey create(Component path, String key) {
        return new ComponentHintKey(null, path, key, null);
    }

    public static ComponentHintKey create(String fullKey) {
        return new ComponentHintKey(null, null, null, fullKey);
    }

    private ComponentHintKey(Provider<Component> componentProvider, Component component, String keyName, String fullKey) {
        this.componentProvider = componentProvider;
        this.component = component;
        this.keyName = keyName;
        this.fullKey = fullKey;
    }

    public String getKey() {
        return this.fullKey != null ? this.fullKey : this.keyFor(this.component != null ? this.component : (Component)this.componentProvider.get(), this.keyName);
    }

    protected String keyFor(Component component, String keyName) {
        return UiHintContainer.Util.hintPathFor(component) + "-" + keyName;
    }

    public boolean matches(Component component, String keyName) {
        String key = this.getKey();
        String keyOfProvided = this.keyFor(component, keyName);
        return keyOfProvided.equals(key);
    }

    public void set(Bookmark bookmark, String value) {
        if (bookmark == null) {
            return;
        }
        if (value != null) {
            this.getHintStore().set(bookmark, this.getKey(), value);
        } else {
            this.remove(bookmark);
        }
    }

    public String get(Bookmark bookmark) {
        if (bookmark == null) {
            return null;
        }
        return this.getHintStore().get(bookmark, this.getKey());
    }

    public void remove(Bookmark bookmark) {
        if (bookmark == null) {
            return;
        }
        String key = this.getKey();
        this.getHintStore().remove(bookmark, key);
    }

    public void hintTo(Bookmark bookmark, PageParameters pageParameters, String prefix) {
        String value = this.get(bookmark);
        if (value == null) {
            return;
        }
        String prefixedKey = prefix + this.getKey();
        pageParameters.add(prefixedKey, (Object)value);
    }

    public static ComponentHintKey noop() {
        return new ComponentHintKey(null, null, null, null){
            private static final long serialVersionUID = 1L;

            @Override
            public String getKey() {
                return null;
            }

            @Override
            public void set(Bookmark bookmark, String value) {
            }

            @Override
            public String get(Bookmark bookmark) {
                return null;
            }

            @Override
            public void remove(Bookmark bookmark) {
            }
        };
    }

    HintStore getHintStore() {
        return this.getIsisSessionFactory().getServicesInjector().lookupService(HintStore.class).orElse(null);
    }

    IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }
}

