/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.models;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ScalarModelWithMultiPending
extends Serializable {
    public ArrayList<ObjectAdapterMemento> getMultiPending();

    public void setMultiPending(ArrayList<ObjectAdapterMemento> var1);

    public ScalarModel getScalarModel();

    public static class Util {
        private static final Logger LOG = LoggerFactory.getLogger(Util.class);

        public static IModel<ArrayList<ObjectAdapterMemento>> createModel(ScalarModel model) {
            return Util.createModel(model.asScalarModelWithMultiPending());
        }

        public static Model<ArrayList<ObjectAdapterMemento>> createModel(final ScalarModelWithMultiPending owner) {
            return new Model<ArrayList<ObjectAdapterMemento>>(){
                private static final long serialVersionUID = 1L;

                public ArrayList<ObjectAdapterMemento> getObject() {
                    ArrayList<ObjectAdapterMemento> pending = owner.getMultiPending();
                    if (pending != null) {
                        LOG.debug("pending not null: {}", (Object)pending.toString());
                        return pending;
                    }
                    LOG.debug("pending is null");
                    ScalarModel scalarModel = owner.getScalarModel();
                    ObjectAdapterMemento objectAdapterMemento = scalarModel.getObjectAdapterMemento();
                    ArrayList<ObjectAdapterMemento> mementos = objectAdapterMemento != null ? objectAdapterMemento.getList() : null;
                    return mementos;
                }

                public void setObject(ArrayList<ObjectAdapterMemento> adapterMemento) {
                    LOG.debug("setting to: {}", (Object)(adapterMemento != null ? adapterMemento.toString() : null));
                    owner.setMultiPending(adapterMemento);
                    ScalarModel ownerScalarModel = owner.getScalarModel();
                    PersistenceSession persistenceSession = ownerScalarModel.getPersistenceSession();
                    SpecificationLoader specificationLoader = ownerScalarModel.getSpecificationLoader();
                    if (adapterMemento == null) {
                        ownerScalarModel.setObject(null);
                    } else {
                        ArrayList<ObjectAdapterMemento> ownerPending = owner.getMultiPending();
                        if (ownerPending != null) {
                            LOG.debug("setting to pending: {}", (Object)ownerPending.toString());
                            ObjectSpecId objectSpecId = ownerScalarModel.getTypeOfSpecification().getSpecId();
                            ownerScalarModel.setObjectMemento(ObjectAdapterMemento.createForList(adapterMemento, objectSpecId), persistenceSession, specificationLoader);
                        }
                    }
                }
            };
        }
    }
}

