/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.isis.applib.annotation.PromptStyle;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.adapter.concurrency.ConcurrencyChecking;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.object.parseable.ParseableFacet;
import org.apache.isis.core.metamodel.facets.object.promptStyle.PromptStyleFacet;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.fileaccept.FileAcceptFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.mandatory.MandatoryFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.typicallen.TypicalLengthFacet;
import org.apache.isis.core.metamodel.facets.value.bigdecimal.BigDecimalValueFacet;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.apache.isis.core.security.authentication.AuthenticationSessionProvider;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.links.LinksProvider;
import org.apache.isis.viewer.wicket.model.mementos.ActionParameterMemento;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.mementos.PropertyMemento;
import org.apache.isis.viewer.wicket.model.mementos.SpecUtils;
import org.apache.isis.viewer.wicket.model.models.ActionArgumentModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.FormExecutorContext;
import org.apache.isis.viewer.wicket.model.models.InlinePromptContext;
import org.apache.isis.viewer.wicket.model.models.ScalarModelWithMultiPending;
import org.apache.isis.viewer.wicket.model.models.ScalarModelWithPending;

public class ScalarModel
extends EntityModel
implements LinksProvider,
FormExecutorContext,
ActionArgumentModel {
    private static final long serialVersionUID = 1L;
    private final Kind kind;
    private final EntityModel parentEntityModel;
    private ActionParameterMemento parameterMemento;
    private PropertyMemento propertyMemento;
    private List<LinkAndLabel> linkAndLabels = _Lists.newArrayList();
    private InlinePromptContext inlinePromptContext;
    private boolean actionWithInlineAsIfEdit;
    private transient ObjectAdapter[] actionArgsHint;

    @Override
    public ObjectAdapter load() {
        return this.kind.load(this);
    }

    private ObjectAdapter loadFromSuper() {
        return super.load();
    }

    public ScalarModel(EntityModel parentEntityModel, ActionParameterMemento apm) {
        super(EntityModel.Mode.EDIT, EntityModel.RenderingHint.REGULAR);
        this.kind = Kind.PARAMETER;
        this.parentEntityModel = parentEntityModel;
        this.parameterMemento = apm;
        this.init();
    }

    public ScalarModel(EntityModel parentEntityModel, PropertyMemento pm, EntityModel.Mode mode, EntityModel.RenderingHint renderingHint) {
        super(mode, renderingHint);
        this.kind = Kind.PROPERTY;
        this.parentEntityModel = parentEntityModel;
        this.propertyMemento = pm;
        this.init();
        this.getAndStore(parentEntityModel);
    }

    private void init() {
        this.kind.init(this);
    }

    @Override
    public void reset() {
        this.kind.reset(this);
    }

    @Override
    public boolean isWithinPrompt() {
        return FormExecutorContext.Util.isWithinPrompt(this);
    }

    @Override
    public EntityModel getParentEntityModel() {
        return this.parentEntityModel;
    }

    private void getAndStore(EntityModel parentEntityModel) {
        ObjectAdapterMemento parentAdapterMemento = parentEntityModel.getObjectAdapterMemento();
        OneToOneAssociation property = this.propertyMemento.getProperty(this.getSpecificationLoader());
        ObjectAdapter parentAdapter = parentAdapterMemento.getObjectAdapter(ConcurrencyChecking.CHECK, this.getPersistenceSession(), this.getSpecificationLoader());
        ScalarModel.setObjectFromPropertyIfVisible(this, property, parentAdapter);
    }

    private static void setObjectFromPropertyIfVisible(ScalarModel scalarModel, OneToOneAssociation property, ObjectAdapter parentAdapter) {
        Where where = scalarModel.getRenderingHint().asWhere();
        Consent visibility = property.isVisible((ManagedObject)parentAdapter, InteractionInitiatedBy.FRAMEWORK, where);
        ObjectAdapter associatedAdapter = visibility.isAllowed() ? property.get(parentAdapter, InteractionInitiatedBy.USER) : null;
        scalarModel.setObject(associatedAdapter);
    }

    public boolean isCollection() {
        return this.kind.isCollection(this);
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getName() {
        return this.kind.getName(this);
    }

    public PropertyMemento getPropertyMemento() {
        return this.propertyMemento;
    }

    @Override
    public ActionParameterMemento getParameterMemento() {
        return this.parameterMemento;
    }

    @Override
    public ObjectSpecification getTypeOfSpecification() {
        return this.kind.getScalarTypeSpec(this);
    }

    public boolean isScalarTypeAnyOf(Class<?> ... requiredClass) {
        String fullName = this.getTypeOfSpecification().getFullIdentifier();
        return _NullSafe.stream((Object[])requiredClass).map(Class::getName).anyMatch(fullName::equals);
    }

    public boolean isScalarTypeSubtypeOf(Class<?> requiredClass) {
        Class scalarType = this.getTypeOfSpecification().getCorrespondingClass();
        return _NullSafe.streamNullable(requiredClass).anyMatch(x -> x.isAssignableFrom(scalarType));
    }

    public String getObjectAsString() {
        ObjectAdapter adapter = (ObjectAdapter)this.getObject();
        if (adapter == null) {
            return null;
        }
        return adapter.titleString(null);
    }

    @Override
    public void setObject(ObjectAdapter adapter) {
        if (adapter == null) {
            super.setObject(null);
            return;
        }
        Object pojo = adapter.getPojo();
        if (pojo == null) {
            super.setObject(null);
            return;
        }
        if (this.isCollection()) {
            List<ObjectAdapterMemento> listOfMementos = _NullSafe.stream((Iterable)((Iterable)pojo)).map(ObjectAdapterMemento.Functions.fromPojo((ObjectAdapterProvider)this.getPersistenceSession())).collect(Collectors.toList());
            ObjectAdapterMemento memento = ObjectAdapterMemento.createForList(listOfMementos, this.getTypeOfSpecification().getSpecId());
            super.setObjectMemento(memento, this.getPersistenceSession(), this.getSpecificationLoader());
        } else {
            super.setObject(adapter);
        }
    }

    public void setObjectAsString(String enteredText) {
        ParseableFacet parseableFacet = (ParseableFacet)this.getTypeOfSpecification().getFacet(ParseableFacet.class);
        if (parseableFacet == null) {
            throw new RuntimeException("unable to parse string for " + this.getTypeOfSpecification().getFullIdentifier());
        }
        ObjectAdapter adapter = parseableFacet.parseTextEntry((ObjectAdapter)this.getObject(), enteredText, InteractionInitiatedBy.USER);
        this.setObject(adapter);
    }

    public boolean whetherHidden() {
        Where where = this.getRenderingHint().asWhere();
        return this.kind.whetherHidden(this, where);
    }

    public String whetherDisabled() {
        Where where = this.getRenderingHint().asWhere();
        return this.kind.whetherDisabled(this, where);
    }

    public String validate(ObjectAdapter proposedAdapter) {
        return this.kind.validate(this, proposedAdapter);
    }

    @Override
    protected AuthenticationSession getAuthenticationSession() {
        return ((AuthenticationSessionProvider)this.getPersistenceSession().getServicesInjector().lookupServiceElseFail(AuthenticationSessionProvider.class)).getAuthenticationSession();
    }

    public boolean isRequired() {
        return this.kind.isRequired(this);
    }

    public String getCssClass() {
        return this.kind.getCssClass(this);
    }

    public <T extends Facet> T getFacet(Class<T> facetType) {
        return this.kind.getFacet(this, facetType);
    }

    public String getDescribedAs() {
        return this.kind.getDescribedAs(this);
    }

    public String getFileAccept() {
        return this.kind.getFileAccept(this);
    }

    public boolean hasChoices() {
        return this.kind.hasChoices(this);
    }

    public List<ObjectAdapter> getChoices(ObjectAdapter[] argumentsIfAvailable, AuthenticationSession authenticationSession) {
        return this.kind.getChoices(this, argumentsIfAvailable, authenticationSession);
    }

    public boolean hasAutoComplete() {
        return this.kind.hasAutoComplete(this);
    }

    public List<ObjectAdapter> getAutoComplete(String searchTerm, AuthenticationSession authenticationSession) {
        return this.kind.getAutoComplete(this, searchTerm, authenticationSession);
    }

    public int getLength() {
        return this.kind.getLength(this);
    }

    public Integer getScale() {
        return this.kind.getScale(this);
    }

    @Override
    public List<LinkAndLabel> getLinks() {
        return Collections.unmodifiableList(this.linkAndLabels);
    }

    public int getAutoCompleteMinLength() {
        return this.kind.getAutoCompleteOrChoicesMinLength(this);
    }

    public ScalarModelWithPending asScalarModelWithPending() {
        return new ScalarModelWithPending(){
            private static final long serialVersionUID = 1L;

            @Override
            public ObjectAdapterMemento getPending() {
                return ScalarModel.this.getPending();
            }

            @Override
            public void setPending(ObjectAdapterMemento pending) {
                ScalarModel.this.setPending(pending);
            }

            @Override
            public ScalarModel getScalarModel() {
                return ScalarModel.this;
            }
        };
    }

    public ScalarModelWithMultiPending asScalarModelWithMultiPending() {
        return new ScalarModelWithMultiPending(){
            private static final long serialVersionUID = 1L;

            @Override
            public ArrayList<ObjectAdapterMemento> getMultiPending() {
                ObjectAdapterMemento pending = ScalarModel.this.getPending();
                return pending != null ? pending.getList() : null;
            }

            @Override
            public void setMultiPending(ArrayList<ObjectAdapterMemento> pending) {
                ObjectAdapterMemento adapterMemento = ObjectAdapterMemento.createForList(pending, this.getScalarModel().getTypeOfSpecification().getSpecId());
                ScalarModel.this.setPending(adapterMemento);
            }

            @Override
            public ScalarModel getScalarModel() {
                return ScalarModel.this;
            }
        };
    }

    @Override
    public PromptStyle getPromptStyle() {
        PromptStyleFacet facet = this.getFacet(PromptStyleFacet.class);
        if (facet == null) {
            return PromptStyle.INLINE;
        }
        PromptStyle promptStyle = facet.value();
        if (promptStyle == PromptStyle.AS_CONFIGURED) {
            return PromptStyle.INLINE;
        }
        return promptStyle;
    }

    public boolean canEnterEditMode() {
        boolean editable = this.isEnabled();
        return editable && this.isViewMode();
    }

    public boolean isEnabled() {
        return this.whetherDisabled() == null;
    }

    public String getReasonInvalidIfAny() {
        ObjectAdapter associate;
        ObjectAdapter adapter;
        OneToOneAssociation property = this.getPropertyMemento().getProperty(this.getSpecificationLoader());
        Consent validity = property.isAssociationValid((ManagedObject)(adapter = this.getParentEntityModel().load()), (ManagedObject)(associate = (ObjectAdapter)this.getObject()), InteractionInitiatedBy.USER);
        return validity.isAllowed() ? null : validity.getReason();
    }

    public ObjectAdapter applyValue(ObjectAdapter adapter) {
        Object viewModel;
        boolean cloneable;
        OneToOneAssociation property = this.getPropertyMemento().getProperty(this.getSpecificationLoader());
        ObjectAdapter associate = (ObjectAdapter)this.getObject();
        property.set(adapter, associate, InteractionInitiatedBy.USER);
        ViewModelFacet recreatableObjectFacet = (ViewModelFacet)adapter.getSpecification().getFacet(ViewModelFacet.class);
        if (recreatableObjectFacet != null && (cloneable = recreatableObjectFacet.isCloneable(viewModel = adapter.getPojo()))) {
            Object newViewModel = recreatableObjectFacet.clone(viewModel);
            adapter = this.getPersistenceSession().adapterFor(newViewModel);
        }
        return adapter;
    }

    @Override
    protected void onDetach() {
        this.clearPending();
        super.onDetach();
    }

    @Override
    public boolean isInlinePrompt() {
        return this.getPromptStyle() == PromptStyle.INLINE && this.canEnterEditMode();
    }

    @Override
    public InlinePromptContext getInlinePromptContext() {
        return this.inlinePromptContext;
    }

    public void setInlinePromptContext(InlinePromptContext inlinePromptContext) {
        if (this.inlinePromptContext != null) {
            return;
        }
        this.inlinePromptContext = inlinePromptContext;
    }

    public boolean hasActionWithInlineAsIfEdit() {
        return this.actionWithInlineAsIfEdit;
    }

    public void setHasActionWithInlineAsIfEdit(boolean inlineAsIfEditHint) {
        this.actionWithInlineAsIfEdit = inlineAsIfEditHint;
    }

    @Override
    public void setActionArgsHint(ObjectAdapter[] actionArgsHint) {
        this.actionArgsHint = actionArgsHint;
    }

    public ObjectAdapter[] getActionArgsHint() {
        return this.actionArgsHint;
    }

    public String toString() {
        return this.kind.toStringOf(this);
    }

    public static enum Kind {
        PROPERTY{

            @Override
            public String getName(ScalarModel scalarModel) {
                return scalarModel.getPropertyMemento().getProperty(scalarModel.getSpecificationLoader()).getName();
            }

            @Override
            public ObjectSpecification getScalarTypeSpec(ScalarModel scalarModel) {
                ObjectSpecId type = scalarModel.getPropertyMemento().getType();
                return SpecUtils.getSpecificationFor(type, scalarModel.getSpecificationLoader());
            }

            @Override
            public String getIdentifier(ScalarModel scalarModel) {
                return scalarModel.getPropertyMemento().getIdentifier();
            }

            @Override
            public String getCssClass(ScalarModel scalarModel) {
                String objectSpecId = scalarModel.getParentEntityModel().getTypeOfSpecification().getSpecId().asString().replace(".", "-");
                String propertyId = this.getIdentifier(scalarModel);
                return "isis-" + objectSpecId + "-" + propertyId;
            }

            @Override
            public boolean whetherHidden(ScalarModel scalarModel, Where where) {
                ObjectAdapter parentAdapter = scalarModel.getParentEntityModel().load();
                OneToOneAssociation property = scalarModel.getPropertyMemento().getProperty(scalarModel.getSpecificationLoader());
                try {
                    Consent visibility = property.isVisible((ManagedObject)parentAdapter, InteractionInitiatedBy.USER, where);
                    return visibility.isVetoed();
                }
                catch (Exception ex) {
                    return true;
                }
            }

            @Override
            public String whetherDisabled(ScalarModel scalarModel, Where where) {
                ObjectAdapter parentAdapter = scalarModel.getParentEntityModel().load();
                OneToOneAssociation property = scalarModel.getPropertyMemento().getProperty(scalarModel.getSpecificationLoader());
                try {
                    Consent usable = property.isUsable((ManagedObject)parentAdapter, InteractionInitiatedBy.USER, where);
                    return usable.isAllowed() ? null : usable.getReason();
                }
                catch (Exception ex) {
                    return ex.getLocalizedMessage();
                }
            }

            @Override
            public String parseAndValidate(ScalarModel scalarModel, String proposedPojoAsStr) {
                OneToOneAssociation property = scalarModel.getPropertyMemento().getProperty(scalarModel.getSpecificationLoader());
                ParseableFacet parseableFacet = (ParseableFacet)property.getFacet(ParseableFacet.class);
                if (parseableFacet == null) {
                    parseableFacet = (ParseableFacet)property.getSpecification().getFacet(ParseableFacet.class);
                }
                try {
                    ObjectAdapter parentAdapter = scalarModel.getParentEntityModel().load();
                    ObjectAdapter currentValue = property.get(parentAdapter, InteractionInitiatedBy.USER);
                    ObjectAdapter proposedAdapter = parseableFacet.parseTextEntry(currentValue, proposedPojoAsStr, InteractionInitiatedBy.USER);
                    Consent valid = property.isAssociationValid((ManagedObject)parentAdapter, (ManagedObject)proposedAdapter, InteractionInitiatedBy.USER);
                    return valid.isAllowed() ? null : valid.getReason();
                }
                catch (ConcurrencyException ex) {
                    return null;
                }
                catch (Exception ex) {
                    return ex.getLocalizedMessage();
                }
            }

            @Override
            public String validate(ScalarModel scalarModel, ObjectAdapter proposedAdapter) {
                ObjectAdapter parentAdapter = scalarModel.getParentEntityModel().load();
                OneToOneAssociation property = scalarModel.getPropertyMemento().getProperty(scalarModel.getSpecificationLoader());
                try {
                    Consent valid = property.isAssociationValid((ManagedObject)parentAdapter, (ManagedObject)proposedAdapter, InteractionInitiatedBy.USER);
                    return valid.isAllowed() ? null : valid.getReason();
                }
                catch (Exception ex) {
                    return ex.getLocalizedMessage();
                }
            }

            @Override
            public boolean isRequired(ScalarModel scalarModel) {
                OneToOneAssociation facetHolder = scalarModel.getPropertyMemento().getProperty(scalarModel.getSpecificationLoader());
                return 1.isRequired((FacetHolder)facetHolder);
            }

            @Override
            public <T extends Facet> T getFacet(ScalarModel scalarModel, Class<T> facetType) {
                OneToOneAssociation facetHolder = scalarModel.getPropertyMemento().getProperty(scalarModel.getSpecificationLoader());
                return (T)facetHolder.getFacet(facetType);
            }

            @Override
            public boolean hasChoices(ScalarModel scalarModel) {
                PropertyMemento propertyMemento = scalarModel.getPropertyMemento();
                OneToOneAssociation property = propertyMemento.getProperty(scalarModel.getSpecificationLoader());
                return property.hasChoices();
            }

            @Override
            public List<ObjectAdapter> getChoices(ScalarModel scalarModel, ObjectAdapter[] argumentsIfAvailable, AuthenticationSession authenticationSession) {
                PropertyMemento propertyMemento = scalarModel.getPropertyMemento();
                OneToOneAssociation property = propertyMemento.getProperty(scalarModel.getSpecificationLoader());
                ObjectAdapter parentAdapter = scalarModel.getParentEntityModel().load(ConcurrencyChecking.NO_CHECK);
                ObjectAdapter[] choices = property.getChoices(parentAdapter, InteractionInitiatedBy.USER);
                return Kind.choicesAsList(choices);
            }

            @Override
            public boolean hasAutoComplete(ScalarModel scalarModel) {
                PropertyMemento propertyMemento = scalarModel.getPropertyMemento();
                OneToOneAssociation property = propertyMemento.getProperty(scalarModel.getSpecificationLoader());
                return property.hasAutoComplete();
            }

            @Override
            public List<ObjectAdapter> getAutoComplete(ScalarModel scalarModel, String searchArg, AuthenticationSession authenticationSession) {
                PropertyMemento propertyMemento = scalarModel.getPropertyMemento();
                OneToOneAssociation property = propertyMemento.getProperty(scalarModel.getSpecificationLoader());
                ObjectAdapter parentAdapter = scalarModel.getParentEntityModel().load(ConcurrencyChecking.NO_CHECK);
                ObjectAdapter[] choices = property.getAutoComplete(parentAdapter, searchArg, InteractionInitiatedBy.USER);
                return Kind.choicesAsList(choices);
            }

            @Override
            public int getAutoCompleteOrChoicesMinLength(ScalarModel scalarModel) {
                if (scalarModel.hasAutoComplete()) {
                    PropertyMemento propertyMemento = scalarModel.getPropertyMemento();
                    OneToOneAssociation property = propertyMemento.getProperty(scalarModel.getSpecificationLoader());
                    return property.getAutoCompleteMinLength();
                }
                return 0;
            }

            @Override
            public void resetVersion(ScalarModel scalarModel) {
                scalarModel.getParentEntityModel().resetVersion();
            }

            @Override
            public String getDescribedAs(ScalarModel scalarModel) {
                PropertyMemento propertyMemento = scalarModel.getPropertyMemento();
                OneToOneAssociation property = propertyMemento.getProperty(scalarModel.getSpecificationLoader());
                return property.getDescription();
            }

            @Override
            public Integer getLength(ScalarModel scalarModel) {
                PropertyMemento propertyMemento = scalarModel.getPropertyMemento();
                OneToOneAssociation property = propertyMemento.getProperty(scalarModel.getSpecificationLoader());
                BigDecimalValueFacet facet = (BigDecimalValueFacet)property.getFacet(BigDecimalValueFacet.class);
                return facet != null ? facet.getPrecision() : null;
            }

            @Override
            public Integer getScale(ScalarModel scalarModel) {
                PropertyMemento propertyMemento = scalarModel.getPropertyMemento();
                OneToOneAssociation property = propertyMemento.getProperty(scalarModel.getSpecificationLoader());
                BigDecimalValueFacet facet = (BigDecimalValueFacet)property.getFacet(BigDecimalValueFacet.class);
                return facet != null ? facet.getScale() : null;
            }

            @Override
            public int getTypicalLength(ScalarModel scalarModel) {
                PropertyMemento propertyMemento = scalarModel.getPropertyMemento();
                OneToOneAssociation property = propertyMemento.getProperty(scalarModel.getSpecificationLoader());
                TypicalLengthFacet facet = (TypicalLengthFacet)property.getFacet(TypicalLengthFacet.class);
                return facet != null ? facet.value() : 25;
            }

            @Override
            public String getFileAccept(ScalarModel scalarModel) {
                PropertyMemento propertyMemento = scalarModel.getPropertyMemento();
                OneToOneAssociation property = propertyMemento.getProperty(scalarModel.getSpecificationLoader());
                FileAcceptFacet facet = (FileAcceptFacet)property.getFacet(FileAcceptFacet.class);
                return facet != null ? (String)facet.value() : null;
            }

            @Override
            public void init(ScalarModel scalarModel) {
                this.reset(scalarModel);
            }

            @Override
            public void reset(ScalarModel scalarModel) {
                OneToOneAssociation property = scalarModel.propertyMemento.getProperty(scalarModel.getSpecificationLoader());
                ObjectAdapter parentAdapter = scalarModel.getParentEntityModel().load();
                ScalarModel.setObjectFromPropertyIfVisible(scalarModel, property, parentAdapter);
            }

            @Override
            public ObjectAdapter load(ScalarModel scalarModel) {
                return scalarModel.loadFromSuper();
            }

            @Override
            public boolean isCollection(ScalarModel scalarModel) {
                return false;
            }

            @Override
            public String toStringOf(ScalarModel scalarModel) {
                return this.name() + ": " + scalarModel.getPropertyMemento().toString();
            }
        }
        ,
        PARAMETER{

            @Override
            public String getName(ScalarModel scalarModel) {
                return scalarModel.getParameterMemento().getActionParameter(scalarModel.getSpecificationLoader()).getName();
            }

            @Override
            public ObjectSpecification getScalarTypeSpec(ScalarModel scalarModel) {
                return scalarModel.getParameterMemento().getSpecification(scalarModel.getSpecificationLoader());
            }

            @Override
            public String getIdentifier(ScalarModel scalarModel) {
                return "" + scalarModel.getParameterMemento().getNumber();
            }

            @Override
            public String getCssClass(ScalarModel scalarModel) {
                ObjectAdapterMemento adapterMemento = scalarModel.getObjectAdapterMemento();
                if (adapterMemento == null) {
                    return null;
                }
                ObjectActionParameter actionParameter = scalarModel.getParameterMemento().getActionParameter(scalarModel.getSpecificationLoader());
                ObjectAction action = actionParameter.getAction();
                String objectSpecId = action.getOnType().getSpecId().asString().replace(".", "-");
                String parmId = actionParameter.getId();
                return "isis-" + objectSpecId + "-" + action.getId() + "-" + parmId;
            }

            @Override
            public String whetherDisabled(ScalarModel scalarModel, Where where) {
                return null;
            }

            @Override
            public boolean whetherHidden(ScalarModel scalarModel, Where where) {
                return false;
            }

            @Override
            public String parseAndValidate(ScalarModel scalarModel, String proposedPojoAsStr) {
                ObjectActionParameter parameter = scalarModel.getParameterMemento().getActionParameter(scalarModel.getSpecificationLoader());
                try {
                    ObjectAdapter parentAdapter = scalarModel.getParentEntityModel().load();
                    String invalidReasonIfAny = parameter.isValid(parentAdapter, (Object)proposedPojoAsStr, InteractionInitiatedBy.USER);
                    return invalidReasonIfAny;
                }
                catch (Exception ex) {
                    return ex.getLocalizedMessage();
                }
            }

            @Override
            public String validate(ScalarModel scalarModel, ObjectAdapter proposedAdapter) {
                ObjectActionParameter parameter = scalarModel.getParameterMemento().getActionParameter(scalarModel.getSpecificationLoader());
                try {
                    ObjectAdapter parentAdapter = scalarModel.getParentEntityModel().load();
                    String invalidReasonIfAny = parameter.isValid(parentAdapter, proposedAdapter.getPojo(), InteractionInitiatedBy.USER);
                    return invalidReasonIfAny;
                }
                catch (Exception ex) {
                    return ex.getLocalizedMessage();
                }
            }

            @Override
            public boolean isRequired(ScalarModel scalarModel) {
                ObjectActionParameter facetHolder = scalarModel.getParameterMemento().getActionParameter(scalarModel.getSpecificationLoader());
                return 2.isRequired((FacetHolder)facetHolder);
            }

            @Override
            public <T extends Facet> T getFacet(ScalarModel scalarModel, Class<T> facetType) {
                ObjectActionParameter facetHolder = scalarModel.getParameterMemento().getActionParameter(scalarModel.getSpecificationLoader());
                return (T)facetHolder.getFacet(facetType);
            }

            @Override
            public boolean hasChoices(ScalarModel scalarModel) {
                ActionParameterMemento parameterMemento = scalarModel.getParameterMemento();
                ObjectActionParameter actionParameter = parameterMemento.getActionParameter(scalarModel.getSpecificationLoader());
                return actionParameter.hasChoices();
            }

            @Override
            public List<ObjectAdapter> getChoices(ScalarModel scalarModel, ObjectAdapter[] argumentsIfAvailable, AuthenticationSession authenticationSession) {
                ActionParameterMemento parameterMemento = scalarModel.getParameterMemento();
                ObjectActionParameter actionParameter = parameterMemento.getActionParameter(scalarModel.getSpecificationLoader());
                ObjectAdapter parentAdapter = scalarModel.getParentEntityModel().load();
                ObjectAdapter[] choices = actionParameter.getChoices(parentAdapter, argumentsIfAvailable, InteractionInitiatedBy.USER);
                return Kind.choicesAsList(choices);
            }

            @Override
            public boolean hasAutoComplete(ScalarModel scalarModel) {
                ActionParameterMemento parameterMemento = scalarModel.getParameterMemento();
                ObjectActionParameter actionParameter = parameterMemento.getActionParameter(scalarModel.getSpecificationLoader());
                return actionParameter.hasAutoComplete();
            }

            @Override
            public List<ObjectAdapter> getAutoComplete(ScalarModel scalarModel, String searchArg, AuthenticationSession authenticationSession) {
                ActionParameterMemento parameterMemento = scalarModel.getParameterMemento();
                ObjectActionParameter actionParameter = parameterMemento.getActionParameter(scalarModel.getSpecificationLoader());
                ObjectAdapter parentAdapter = scalarModel.getParentEntityModel().load(ConcurrencyChecking.NO_CHECK);
                ObjectAdapter[] choices = actionParameter.getAutoComplete(parentAdapter, searchArg, InteractionInitiatedBy.USER);
                return Kind.choicesAsList(choices);
            }

            @Override
            public int getAutoCompleteOrChoicesMinLength(ScalarModel scalarModel) {
                if (scalarModel.hasAutoComplete()) {
                    ActionParameterMemento parameterMemento = scalarModel.getParameterMemento();
                    ObjectActionParameter actionParameter = parameterMemento.getActionParameter(scalarModel.getSpecificationLoader());
                    return actionParameter.getAutoCompleteMinLength();
                }
                return 0;
            }

            @Override
            public void resetVersion(ScalarModel scalarModel) {
            }

            @Override
            public String getDescribedAs(ScalarModel scalarModel) {
                ActionParameterMemento parameterMemento = scalarModel.getParameterMemento();
                ObjectActionParameter actionParameter = parameterMemento.getActionParameter(scalarModel.getSpecificationLoader());
                return actionParameter.getDescription();
            }

            @Override
            public Integer getLength(ScalarModel scalarModel) {
                ActionParameterMemento parameterMemento = scalarModel.getParameterMemento();
                ObjectActionParameter actionParameter = parameterMemento.getActionParameter(scalarModel.getSpecificationLoader());
                BigDecimalValueFacet facet = (BigDecimalValueFacet)actionParameter.getFacet(BigDecimalValueFacet.class);
                return facet != null ? facet.getPrecision() : null;
            }

            @Override
            public Integer getScale(ScalarModel scalarModel) {
                ActionParameterMemento parameterMemento = scalarModel.getParameterMemento();
                ObjectActionParameter actionParameter = parameterMemento.getActionParameter(scalarModel.getSpecificationLoader());
                BigDecimalValueFacet facet = (BigDecimalValueFacet)actionParameter.getFacet(BigDecimalValueFacet.class);
                return facet != null ? facet.getScale() : null;
            }

            @Override
            public int getTypicalLength(ScalarModel scalarModel) {
                ActionParameterMemento parameterMemento = scalarModel.getParameterMemento();
                ObjectActionParameter actionParameter = parameterMemento.getActionParameter(scalarModel.getSpecificationLoader());
                TypicalLengthFacet facet = (TypicalLengthFacet)actionParameter.getFacet(TypicalLengthFacet.class);
                return facet != null ? facet.value() : 25;
            }

            @Override
            public String getFileAccept(ScalarModel scalarModel) {
                ActionParameterMemento parameterMemento = scalarModel.getParameterMemento();
                ObjectActionParameter actionParameter = parameterMemento.getActionParameter(scalarModel.getSpecificationLoader());
                FileAcceptFacet facet = (FileAcceptFacet)actionParameter.getFacet(FileAcceptFacet.class);
                return facet != null ? (String)facet.value() : null;
            }

            @Override
            public void init(ScalarModel scalarModel) {
            }

            @Override
            public void reset(ScalarModel scalarModel) {
                ObjectActionParameter actionParameter = scalarModel.parameterMemento.getActionParameter(scalarModel.getSpecificationLoader());
                ObjectAdapter parentAdapter = scalarModel.getParentEntityModel().load(ConcurrencyChecking.NO_CHECK);
                ObjectAdapter defaultAdapter = actionParameter.getDefault(parentAdapter);
                scalarModel.setObject(defaultAdapter);
            }

            @Override
            public ObjectAdapter load(ScalarModel scalarModel) {
                ActionParameterMemento parameterMemento = scalarModel.getParameterMemento();
                ObjectActionParameter actionParameter = parameterMemento.getActionParameter(scalarModel.getSpecificationLoader());
                ObjectAdapter objectAdapter = scalarModel.loadFromSuper();
                if (objectAdapter != null) {
                    return objectAdapter;
                }
                if (actionParameter.getFeatureType() == FeatureType.ACTION_PARAMETER_SCALAR) {
                    return objectAdapter;
                }
                return objectAdapter;
            }

            @Override
            public boolean isCollection(ScalarModel scalarModel) {
                ActionParameterMemento parameterMemento = scalarModel.getParameterMemento();
                ObjectActionParameter actionParameter = parameterMemento.getActionParameter(scalarModel.getSpecificationLoader());
                return actionParameter.getFeatureType() == FeatureType.ACTION_PARAMETER_COLLECTION;
            }

            @Override
            public String toStringOf(ScalarModel scalarModel) {
                return this.name() + ": " + scalarModel.getParameterMemento().toString();
            }
        };


        private static List<ObjectAdapter> choicesAsList(ObjectAdapter[] choices) {
            if (choices != null && choices.length > 0) {
                return Arrays.asList(choices);
            }
            return Collections.emptyList();
        }

        public abstract String getName(ScalarModel var1);

        public abstract ObjectSpecification getScalarTypeSpec(ScalarModel var1);

        public abstract String getIdentifier(ScalarModel var1);

        public abstract boolean whetherHidden(ScalarModel var1, Where var2);

        public abstract String whetherDisabled(ScalarModel var1, Where var2);

        public abstract String parseAndValidate(ScalarModel var1, String var2);

        public abstract String validate(ScalarModel var1, ObjectAdapter var2);

        public abstract String getCssClass(ScalarModel var1);

        public abstract boolean isRequired(ScalarModel var1);

        public abstract <T extends Facet> T getFacet(ScalarModel var1, Class<T> var2);

        static boolean isRequired(FacetHolder facetHolder) {
            MandatoryFacet mandatoryFacet = (MandatoryFacet)facetHolder.getFacet(MandatoryFacet.class);
            boolean required = mandatoryFacet != null && !mandatoryFacet.isInvertedSemantics();
            return required;
        }

        public abstract boolean hasChoices(ScalarModel var1);

        public abstract List<ObjectAdapter> getChoices(ScalarModel var1, ObjectAdapter[] var2, AuthenticationSession var3);

        public abstract boolean hasAutoComplete(ScalarModel var1);

        public abstract List<ObjectAdapter> getAutoComplete(ScalarModel var1, String var2, AuthenticationSession var3);

        public abstract int getAutoCompleteOrChoicesMinLength(ScalarModel var1);

        public abstract void resetVersion(ScalarModel var1);

        public abstract String getDescribedAs(ScalarModel var1);

        public abstract Integer getLength(ScalarModel var1);

        public abstract Integer getScale(ScalarModel var1);

        public abstract int getTypicalLength(ScalarModel var1);

        public abstract String getFileAccept(ScalarModel var1);

        public abstract void init(ScalarModel var1);

        public abstract void reset(ScalarModel var1);

        public abstract ObjectAdapter load(ScalarModel var1);

        public abstract boolean isCollection(ScalarModel var1);

        public abstract String toStringOf(ScalarModel var1);
    }
}

