/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.models;

import java.util.Map;
import org.apache.isis.applib.annotation.BookmarkPolicy;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.layout.component.CollectionLayoutData;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.concurrency.ConcurrencyChecking;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facets.object.bookmarkpolicy.BookmarkPolicyFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.viewer.wicket.model.common.PageParametersUtils;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.mementos.PageParameterNames;
import org.apache.isis.viewer.wicket.model.mementos.PropertyMemento;
import org.apache.isis.viewer.wicket.model.models.BookmarkableModel;
import org.apache.isis.viewer.wicket.model.models.HintPageParameterSerializer;
import org.apache.isis.viewer.wicket.model.models.ObjectAdapterModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.model.util.ComponentHintKey;
import org.apache.wicket.Component;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class EntityModel
extends BookmarkableModel<ObjectAdapter>
implements ObjectAdapterModel,
UiHintContainer {
    private static final long serialVersionUID = 1L;
    private final Map<PropertyMemento, ScalarModel> propertyScalarModels;
    private ObjectAdapterMemento adapterMemento;
    private ObjectAdapterMemento contextAdapterIfAny;
    private Mode mode;
    private RenderingHint renderingHint;
    private final PendingModel pendingModel;
    private ConcurrencyException concurrencyException;
    private CollectionLayoutData collectionLayoutData;

    public static PageParameters createPageParameters(ObjectAdapter adapter) {
        PageParameters pageParameters = PageParametersUtils.newPageParameters();
        Boolean persistent = adapter != null && adapter.representsPersistent();
        if (persistent.booleanValue()) {
            String oidStr = adapter.getOid().enStringNoVersion();
            PageParameterNames.OBJECT_OID.addStringTo(pageParameters, oidStr);
        }
        return pageParameters;
    }

    public void resetVersion() {
        if (this.getObjectAdapterMemento() == null) {
            return;
        }
        PersistenceSession persistenceSession = this.getPersistenceSession();
        SpecificationLoader specificationLoader = this.getSpecificationLoader();
        this.getObjectAdapterMemento().resetVersion(persistenceSession, specificationLoader);
    }

    public EntityModel(Mode mode, RenderingHint renderingHint) {
        this(_Maps.newHashMap(), null, mode, renderingHint);
    }

    public EntityModel(PageParameters pageParameters) {
        this(ObjectAdapterMemento.createPersistent(EntityModel.rootOidFrom(pageParameters)));
    }

    public EntityModel(ObjectAdapter adapter) {
        this(ObjectAdapterMemento.createOrNull(adapter));
        this.setObject(adapter);
    }

    public EntityModel(ObjectAdapterMemento adapterMemento) {
        this(adapterMemento, _Maps.newHashMap());
    }

    public EntityModel(ObjectAdapterMemento adapterMemento, Map<PropertyMemento, ScalarModel> propertyScalarModels) {
        this(propertyScalarModels, adapterMemento);
    }

    private EntityModel(Map<PropertyMemento, ScalarModel> propertyScalarModels, ObjectAdapterMemento adapterMemento) {
        this(propertyScalarModels, adapterMemento, Mode.VIEW, RenderingHint.REGULAR);
    }

    private EntityModel(Map<PropertyMemento, ScalarModel> propertyScalarModels, ObjectAdapterMemento adapterMemento, Mode mode, RenderingHint renderingHint) {
        this.adapterMemento = adapterMemento;
        this.pendingModel = new PendingModel(this);
        this.propertyScalarModels = propertyScalarModels;
        this.mode = mode;
        this.renderingHint = renderingHint;
    }

    public static String oidStr(PageParameters pageParameters) {
        return PageParameterNames.OBJECT_OID.getStringFrom(pageParameters);
    }

    private static RootOid rootOidFrom(PageParameters pageParameters) {
        return (RootOid)Oid.unmarshaller().unmarshal(EntityModel.oidStr(pageParameters), RootOid.class);
    }

    @Override
    public PageParameters getPageParameters() {
        PageParameters pageParameters = EntityModel.createPageParameters((ObjectAdapter)this.getObject());
        HintPageParameterSerializer.hintStoreToPageParameters(pageParameters, this);
        return pageParameters;
    }

    @Override
    public boolean isInlinePrompt() {
        return false;
    }

    @Override
    public PageParameters getPageParametersWithoutUiHints() {
        return EntityModel.createPageParameters((ObjectAdapter)this.getObject());
    }

    @Override
    public String getHint(Component component, String keyName) {
        ComponentHintKey componentHintKey = ComponentHintKey.create(component, keyName);
        if (componentHintKey != null) {
            return componentHintKey.get(this.getObjectAdapterMemento().asHintingBookmark());
        }
        return null;
    }

    @Override
    public void setHint(Component component, String keyName, String hintValue) {
        ComponentHintKey componentHintKey = ComponentHintKey.create(component, keyName);
        componentHintKey.set(this.getObjectAdapterMemento().asHintingBookmark(), hintValue);
    }

    @Override
    public void clearHint(Component component, String attributeName) {
        this.setHint(component, attributeName, null);
    }

    @Override
    public String getTitle() {
        return ((ObjectAdapter)this.getObject()).titleString(null);
    }

    @Override
    public boolean hasAsRootPolicy() {
        return this.hasBookmarkPolicy(BookmarkPolicy.AS_ROOT);
    }

    public boolean hasAsChildPolicy() {
        return this.hasBookmarkPolicy(BookmarkPolicy.AS_CHILD);
    }

    private boolean hasBookmarkPolicy(BookmarkPolicy policy) {
        BookmarkPolicyFacet facet = this.getBookmarkPolicyFacetIfAny();
        return facet != null && facet.value() == policy;
    }

    private BookmarkPolicyFacet getBookmarkPolicyFacetIfAny() {
        ObjectSpecId specId = this.getObjectAdapterMemento().getObjectSpecId();
        ObjectSpecification objectSpec = this.getSpecificationLoader().lookupBySpecId(specId);
        return (BookmarkPolicyFacet)objectSpec.getFacet(BookmarkPolicyFacet.class);
    }

    public ObjectAdapterMemento getObjectAdapterMemento() {
        return this.adapterMemento;
    }

    @Override
    public ObjectSpecification getTypeOfSpecification() {
        if (this.adapterMemento == null) {
            return null;
        }
        return this.getSpecificationFor(this.adapterMemento.getObjectSpecId());
    }

    private ObjectSpecification getSpecificationFor(ObjectSpecId objectSpecId) {
        return this.getSpecificationLoader().lookupBySpecId(objectSpecId);
    }

    public ObjectAdapter load(ConcurrencyChecking concurrencyChecking) {
        if (this.adapterMemento == null) {
            return null;
        }
        ObjectAdapter objectAdapter = this.adapterMemento.getObjectAdapter(concurrencyChecking, this.getPersistenceSession(), this.getSpecificationLoader());
        return objectAdapter;
    }

    public ObjectAdapter load() {
        ObjectAdapter objectAdapter = this.load(ConcurrencyChecking.CHECK);
        return objectAdapter;
    }

    public void setObject(ObjectAdapter adapter) {
        super.setObject((Object)adapter);
        this.adapterMemento = ObjectAdapterMemento.createOrNull(adapter);
    }

    public void setObjectMemento(ObjectAdapterMemento memento, PersistenceSession persistenceSession, SpecificationLoader specificationLoader) {
        super.setObject(memento != null ? memento.getObjectAdapter(ConcurrencyChecking.CHECK, persistenceSession, specificationLoader) : null);
        this.adapterMemento = memento;
    }

    public ScalarModel getPropertyModel(PropertyMemento pm, Mode mode, RenderingHint renderingHint) {
        ScalarModel scalarModel = this.propertyScalarModels.get(pm);
        if (scalarModel == null) {
            scalarModel = new ScalarModel(this, pm, mode, renderingHint);
            this.propertyScalarModels.put(pm, scalarModel);
        }
        return scalarModel;
    }

    public void resetPropertyModels() {
        this.adapterMemento.resetVersion(this.getPersistenceSession(), this.getSpecificationLoader());
        for (PropertyMemento pm : this.propertyScalarModels.keySet()) {
            OneToOneAssociation otoa = pm.getProperty(this.getSpecificationLoader());
            ScalarModel scalarModel = this.propertyScalarModels.get(pm);
            ObjectAdapter adapter = (ObjectAdapter)this.getObject();
            ObjectAdapter associatedAdapter = otoa.get(adapter, InteractionInitiatedBy.USER);
            scalarModel.setObject(associatedAdapter);
        }
    }

    @Override
    public RenderingHint getRenderingHint() {
        return this.renderingHint;
    }

    @Override
    public void setRenderingHint(RenderingHint renderingHint) {
        this.renderingHint = renderingHint;
    }

    @Override
    public ObjectAdapterMemento getContextAdapterIfAny() {
        return this.contextAdapterIfAny;
    }

    @Override
    public void setContextAdapterIfAny(ObjectAdapterMemento contextAdapterIfAny) {
        this.contextAdapterIfAny = contextAdapterIfAny;
    }

    @Override
    public Mode getMode() {
        return this.mode;
    }

    protected void setMode(Mode mode) {
        this.mode = mode;
    }

    public boolean isViewMode() {
        return this.mode == Mode.VIEW;
    }

    public boolean isEditMode() {
        return this.mode == Mode.EDIT;
    }

    public EntityModel toEditMode() {
        this.setMode(Mode.EDIT);
        for (ScalarModel scalarModel : this.propertyScalarModels.values()) {
            scalarModel.toEditMode();
        }
        return this;
    }

    public EntityModel toViewMode() {
        this.setMode(Mode.VIEW);
        for (ScalarModel scalarModel : this.propertyScalarModels.values()) {
            scalarModel.toViewMode();
        }
        return this;
    }

    protected void onDetach() {
        super.onDetach();
        for (PropertyMemento propertyMemento : this.propertyScalarModels.keySet()) {
            ScalarModel scalarModel = this.propertyScalarModels.get(propertyMemento);
            scalarModel.detach();
        }
    }

    public void setException(ConcurrencyException ex) {
        this.concurrencyException = ex;
    }

    public String getAndClearConcurrencyExceptionIfAny() {
        if (this.concurrencyException == null) {
            return null;
        }
        String message = this.concurrencyException.getMessage();
        this.concurrencyException = null;
        return message;
    }

    public ObjectAdapter getPendingElseCurrentAdapter() {
        return this.pendingModel.getPendingElseCurrentAdapter();
    }

    public ObjectAdapter getPendingAdapter() {
        return this.pendingModel.getPendingAdapter();
    }

    public ObjectAdapterMemento getPending() {
        return this.pendingModel.getPending();
    }

    public void setPending(ObjectAdapterMemento selectedAdapterMemento) {
        this.pendingModel.setPending(selectedAdapterMemento);
    }

    public void clearPending() {
        this.pendingModel.clearPending();
    }

    public CollectionLayoutData getCollectionLayoutData() {
        return this.collectionLayoutData;
    }

    public void setCollectionLayoutData(CollectionLayoutData collectionLayoutData) {
        this.collectionLayoutData = collectionLayoutData;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.adapterMemento == null ? 0 : this.adapterMemento.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityModel other = (EntityModel)obj;
        return !(this.adapterMemento == null ? other.adapterMemento != null : !this.adapterMemento.equals(other.adapterMemento));
    }

    private static final class PendingModel
    extends Model<ObjectAdapterMemento> {
        private static final long serialVersionUID = 1L;
        private final EntityModel entityModel;
        private boolean hasPending;
        private ObjectAdapterMemento pending;

        public PendingModel(EntityModel entityModel) {
            this.entityModel = entityModel;
        }

        public ObjectAdapterMemento getObject() {
            if (this.hasPending) {
                return this.pending;
            }
            ObjectAdapter adapter = (ObjectAdapter)this.entityModel.getObject();
            return ObjectAdapterMemento.createOrNull(adapter);
        }

        public void setObject(ObjectAdapterMemento adapterMemento) {
            this.pending = adapterMemento;
            this.hasPending = true;
        }

        public void clearPending() {
            this.hasPending = false;
            this.pending = null;
        }

        private ObjectAdapter getPendingAdapter() {
            ObjectAdapterMemento memento = this.getObject();
            return memento != null ? memento.getObjectAdapter(ConcurrencyChecking.NO_CHECK, this.entityModel.getPersistenceSession(), this.entityModel.getSpecificationLoader()) : null;
        }

        public ObjectAdapter getPendingElseCurrentAdapter() {
            return this.hasPending ? this.getPendingAdapter() : (ObjectAdapter)this.entityModel.getObject();
        }

        public ObjectAdapterMemento getPending() {
            return this.pending;
        }

        public void setPending(ObjectAdapterMemento selectedAdapterMemento) {
            this.pending = selectedAdapterMemento;
            this.hasPending = true;
        }
    }

    public static enum Mode {
        VIEW,
        EDIT;

    }

    public static enum RenderingHint {
        REGULAR(Where.OBJECT_FORMS),
        PARENTED_PROPERTY_COLUMN(Where.PARENTED_TABLES),
        PARENTED_TITLE_COLUMN(Where.PARENTED_TABLES),
        STANDALONE_PROPERTY_COLUMN(Where.STANDALONE_TABLES),
        STANDALONE_TITLE_COLUMN(Where.STANDALONE_TABLES);

        private final Where where;

        private RenderingHint(Where where) {
            this.where = where;
        }

        public boolean isRegular() {
            return this == REGULAR;
        }

        public boolean isInParentedTable() {
            return this == PARENTED_PROPERTY_COLUMN;
        }

        public boolean isInStandaloneTable() {
            return this == STANDALONE_PROPERTY_COLUMN;
        }

        public boolean isInTable() {
            return this.isInParentedTable() || this.isInStandaloneTable() || this.isInTableTitleColumn();
        }

        public boolean isInTableTitleColumn() {
            return this.isInParentedTableTitleColumn() || this.isInStandaloneTableTitleColumn();
        }

        public boolean isInParentedTableTitleColumn() {
            return this == PARENTED_TITLE_COLUMN;
        }

        public boolean isInStandaloneTableTitleColumn() {
            return this == STANDALONE_TITLE_COLUMN;
        }

        public Where asWhere() {
            return this.where;
        }
    }
}

