/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.mementos;

import java.util.Collection;
import java.util.List;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public enum PageParameterNames {
    OBJECT_OID,
    ANCHOR,
    ACTION_OWNING_SPEC,
    ACTION_TYPE,
    ACTION_ID,
    ACTION_SINGLE_RESULTS_MODE,
    ACTION_PARAM_CONTEXT,
    ACTION_ARGS;


    public String toString() {
        return StringExtensions.toCamelCase((String)this.name());
    }

    public String getStringFrom(PageParameters pageParameters) {
        return this.getStringFrom(pageParameters, null);
    }

    public String getStringFrom(PageParameters pageParameters, String defaultValue) {
        if (pageParameters == null) {
            return defaultValue;
        }
        return pageParameters.get(this.toString()).toString(defaultValue);
    }

    public <T extends Enum<T>> T getEnumFrom(PageParameters pageParameters, Class<T> enumClass) {
        String value = this.getStringFrom(pageParameters);
        return value != null ? (T)Enum.valueOf(enumClass, value) : null;
    }

    public List<String> getListFrom(PageParameters pageParameters) {
        return _Lists.map((Collection)pageParameters.getValues(this.toString()), input -> input.toString());
    }

    public void addStringTo(PageParameters pageParameters, String value) {
        pageParameters.add(this.toString(), (Object)value);
    }

    public void addEnumTo(PageParameters pageParameters, Enum<?> someEnum) {
        this.addStringTo(pageParameters, someEnum.name());
    }

    public void removeFrom(PageParameters pageParameters) {
        pageParameters.remove(this.toString(), new String[0]);
    }
}

