/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer.settings;

import com.google.inject.Singleton;
import org.apache.isis.applib.annotation.PromptStyle;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facets.object.promptStyle.PromptStyleConfiguration;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;

@Singleton
public class WicketViewerSettingsDefault
implements WicketViewerSettings {
    private static final long serialVersionUID = 1L;

    IsisConfiguration getConfiguration() {
        return this.getIsisSessionFactory().getConfiguration();
    }

    IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }

    public int getMaxTitleLengthInStandaloneTables() {
        return this.getConfiguration().getInteger("isis.viewer.wicket.maxTitleLengthInStandaloneTables", this.getMaxTitleLengthInTables());
    }

    public int getMaxTitleLengthInParentedTables() {
        return this.getConfiguration().getInteger("isis.viewer.wicket.maxTitleLengthInParentedTables", this.getMaxTitleLengthInTables());
    }

    private int getMaxTitleLengthInTables() {
        return this.getConfiguration().getInteger("isis.viewer.wicket.maxTitleLengthInTables", 12);
    }

    public String getDatePattern() {
        return this.getConfiguration().getString("isis.viewer.wicket.datePattern", "dd-MM-yyyy");
    }

    public String getDateTimePattern() {
        return this.getConfiguration().getString("isis.viewer.wicket.dateTimePattern", "dd-MM-yyyy HH:mm");
    }

    public String getTimestampPattern() {
        return this.getConfiguration().getString("isis.viewer.wicket.timestampPattern", "yyyy-MM-dd HH:mm:ss.SSS");
    }

    public boolean isReplaceDisabledTagWithReadonlyTag() {
        return this.getConfiguration().getBoolean("isis.viewer.wicket.replaceDisabledTagWithReadonlyTag", true);
    }

    public boolean isPreventDoubleClickForFormSubmit() {
        return this.getConfiguration().getBoolean("isis.viewer.wicket.preventDoubleClickForFormSubmit", true);
    }

    public boolean isPreventDoubleClickForNoArgAction() {
        return this.getConfiguration().getBoolean("isis.viewer.wicket.preventDoubleClickForNoArgAction", true);
    }

    public boolean isUseIndicatorForFormSubmit() {
        return this.getConfiguration().getBoolean("isis.viewer.wicket.useIndicatorForFormSubmit", true);
    }

    public boolean isUseIndicatorForNoArgAction() {
        return this.getConfiguration().getBoolean("isis.viewer.wicket.useIndicatorForNoArgAction", true);
    }

    public PromptStyle getPromptStyle() {
        return PromptStyleConfiguration.parse((IsisConfiguration)this.getConfiguration());
    }

    public boolean isRedirectEvenIfSameObject() {
        return this.getConfiguration().getBoolean("isis.viewer.wicket.redirectEvenIfSameObject", false);
    }
}

