/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer.services;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.hint.HintStore;
import org.apache.wicket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class HintStoreUsingWicketSession
implements HintStore {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HintStoreUsingWicketSession.class);

    public String get(Bookmark bookmark, String key) {
        Map<String, String> hintsForBookmark = this.hintsFor(bookmark);
        String value = hintsForBookmark.get(key);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("GET %s / %s returns %s", bookmark.toString(), key, value));
        }
        return value;
    }

    public void set(Bookmark bookmark, String key, String value) {
        Map<String, String> hintsForBookmark = this.hintsFor(bookmark);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("SET %s / %s to %s", bookmark.toString(), key, value));
        }
        hintsForBookmark.put(key, value);
    }

    public void remove(Bookmark bookmark, String key) {
        Map<String, String> hintsForBookmark = this.hintsFor(bookmark);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("REMOVE %s / %s", bookmark.toString(), key));
        }
        hintsForBookmark.remove(key);
    }

    public Set<String> findHintKeys(Bookmark bookmark) {
        Map<String, String> hintsForBookmark = this.hintsFor(bookmark);
        return hintsForBookmark.keySet();
    }

    public void removeAll(Bookmark bookmark) {
        String sessionAttribute = this.sessionAttributeFor(bookmark);
        Session.get().removeAttribute(sessionAttribute);
    }

    protected Map<String, String> hintsFor(Bookmark bookmark) {
        String sessionAttribute = this.sessionAttributeFor(bookmark);
        LinkedHashMap hints = (LinkedHashMap)Session.get().getAttribute(sessionAttribute);
        if (hints == null) {
            hints = Maps.newLinkedHashMap();
            Session.get().setAttribute(sessionAttribute, (Serializable)hints);
        }
        return hints;
    }

    protected String sessionAttributeFor(Bookmark bookmark) {
        return "hint-" + (bookmark instanceof HintStore.BookmarkWithHintId ? ((HintStore.BookmarkWithHintId)bookmark).toStringUsingHintId() : bookmark.toString());
    }
}

