/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer.integration.wicket;

import com.google.common.base.Throwables;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerComposite;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerForType;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.adapter.concurrency.ConcurrencyChecking;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelInvalidException;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.apache.isis.core.security.authentication.MessageBroker;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.errors.ExceptionModel;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.error.ErrorPage;
import org.apache.isis.viewer.wicket.ui.pages.login.WicketSignInPage;
import org.apache.isis.viewer.wicket.ui.pages.mmverror.MmvErrorPage;
import org.apache.isis.viewer.wicket.viewer.integration.wicket.AuthenticatedWebSessionForIsis;
import org.apache.wicket.Application;
import org.apache.wicket.IPageFactory;
import org.apache.wicket.Page;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.core.request.handler.IPageProvider;
import org.apache.wicket.core.request.handler.ListenerInvocationNotAllowedException;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.AbstractRequestCycleListener;
import org.apache.wicket.request.cycle.PageRequestHandlerTracker;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebRequestCycleForIsis
extends AbstractRequestCycleListener {
    private static final Logger LOG = LoggerFactory.getLogger(WebRequestCycleForIsis.class);
    private PageClassRegistry pageClassRegistry;
    private static final ExceptionRecognizerForType pageExpiredExceptionRecognizer = new ExceptionRecognizerForType(PageExpiredException.class, (Function)new Function<String, String>(){

        @Override
        public String apply(String input) {
            return "Requested page is no longer available.";
        }
    });

    public synchronized void onBeginRequest(RequestCycle requestCycle) {
        if (!Session.exists()) {
            return;
        }
        AuthenticatedWebSessionForIsis wicketSession = AuthenticatedWebSessionForIsis.get();
        AuthenticationSession authenticationSession = wicketSession.getAuthenticationSession();
        if (authenticationSession == null) {
            return;
        }
        this.getIsisSessionFactory().openSession(authenticationSession);
        this.getTransactionManager().startTransaction();
    }

    public void onRequestHandlerResolved(RequestCycle cycle, IRequestHandler handler) {
        if (handler instanceof RenderPageRequestHandler) {
            ConcurrencyChecking.disable();
            MetaModelInvalidException mmie = IsisContext.getMetaModelInvalidExceptionIfAny();
            if (mmie != null) {
                RenderPageRequestHandler requestHandler = (RenderPageRequestHandler)handler;
                IRequestablePage nextPage = requestHandler.getPage();
                if (nextPage instanceof ErrorPage || nextPage instanceof MmvErrorPage) {
                    return;
                }
                throw mmie;
            }
        }
    }

    public void onRequestHandlerExecuted(RequestCycle cycle, IRequestHandler handler) {
        LOG.debug("onRequestHandlerExecuted: handler: {}", (Object)handler);
        if (handler instanceof RenderPageRequestHandler) {
            ConcurrencyChecking.reset((ConcurrencyChecking)ConcurrencyChecking.CHECK);
        }
        if (this.getIsisSessionFactory().inSession()) {
            try {
                this.getTransactionManager().endTransaction();
            }
            catch (Exception ex) {
                RenderPageRequestHandler requestHandler;
                if (this.getTransactionManager().getCurrentTransaction().getState().isComplete()) {
                    this.getTransactionManager().startTransaction();
                }
                if (handler instanceof RenderPageRequestHandler && (requestHandler = (RenderPageRequestHandler)handler).getPage() instanceof ErrorPage) {
                    return;
                }
                PageProvider errorPageProvider = this.errorPageProviderFor(ex);
                throw new RestartResponseException((IPageProvider)errorPageProvider, RenderPageRequestHandler.RedirectPolicy.ALWAYS_REDIRECT);
            }
        }
    }

    public synchronized void onEndRequest(RequestCycle cycle) {
        if (this.getIsisSessionFactory().inSession()) {
            try {
                this.getTransactionManager().endTransaction();
            }
            finally {
                this.getIsisSessionFactory().closeSession();
            }
        }
    }

    public IRequestHandler onException(RequestCycle cycle, Exception ex) {
        MetaModelInvalidException mmie = IsisContext.getMetaModelInvalidExceptionIfAny();
        if (mmie != null) {
            Set validationErrors = mmie.getValidationErrors();
            MmvErrorPage mmvErrorPage = new MmvErrorPage(validationErrors);
            return new RenderPageRequestHandler((IPageProvider)new PageProvider((IRequestablePage)mmvErrorPage), RenderPageRequestHandler.RedirectPolicy.ALWAYS_REDIRECT);
        }
        try {
            if (ex instanceof ListenerInvocationNotAllowedException) {
                ListenerInvocationNotAllowedException linaex = (ListenerInvocationNotAllowedException)ex;
                if (linaex.getComponent() == null || !"cancelButton".equals(linaex.getComponent().getId())) {
                    this.addMessage(null);
                }
                return this.respondGracefully(cycle);
            }
            Stream exceptionRecognizers = this.getServicesInjector().streamServices(ExceptionRecognizer.class);
            String recognizedMessageIfAny = new ExceptionRecognizerComposite(exceptionRecognizers).recognize((Throwable)ex);
            if (recognizedMessageIfAny != null) {
                return this.respondGracefully(cycle);
            }
            List causalChain = Throwables.getCausalChain((Throwable)ex);
            Optional hiddenIfAny = causalChain.stream().filter(ObjectMember.HiddenException.isInstanceOf()).findFirst();
            if (hiddenIfAny.isPresent()) {
                this.addMessage("hidden");
                return this.respondGracefully(cycle);
            }
            Optional disabledIfAny = causalChain.stream().filter(ObjectMember.DisabledException.isInstanceOf()).findFirst();
            if (disabledIfAny.isPresent()) {
                this.addTranslatedMessage(((Throwable)disabledIfAny.get()).getMessage());
                return this.respondGracefully(cycle);
            }
        }
        catch (Exception exceptionRecognizers) {
            // empty catch block
        }
        PageProvider errorPageProvider = this.errorPageProviderFor(ex);
        RenderPageRequestHandler.RedirectPolicy redirectPolicy = ex instanceof PageExpiredException ? RenderPageRequestHandler.RedirectPolicy.NEVER_REDIRECT : RenderPageRequestHandler.RedirectPolicy.ALWAYS_REDIRECT;
        return errorPageProvider != null ? new RenderPageRequestHandler((IPageProvider)errorPageProvider, redirectPolicy) : null;
    }

    private IRequestHandler respondGracefully(RequestCycle cycle) {
        IRequestablePage page = PageRequestHandlerTracker.getFirstHandler((RequestCycle)cycle).getPage();
        PageProvider pageProvider = new PageProvider(page);
        return new RenderPageRequestHandler((IPageProvider)pageProvider);
    }

    private void addMessage(String message) {
        String translatedMessage = this.translate(message);
        this.addTranslatedMessage(translatedMessage);
    }

    private void addTranslatedMessage(String translatedSuffixIfAny) {
        String translatedPrefix = this.translate("Action no longer available");
        String message = translatedSuffixIfAny != null ? String.format("%s (%s)", translatedPrefix, translatedSuffixIfAny) : translatedPrefix;
        this.getMessageBroker().addMessage(message);
    }

    private String translate(String text) {
        if (text == null) {
            return null;
        }
        return this.getTranslationService().translate(WebRequestCycleForIsis.class.getName(), text);
    }

    protected PageProvider errorPageProviderFor(Exception ex) {
        IRequestablePage errorPage = this.errorPageFor(ex);
        return errorPage != null ? new PageProvider(errorPage) : null;
    }

    protected IRequestablePage errorPageFor(Exception ex) {
        ArrayList exceptionRecognizers = _Lists.newArrayList();
        exceptionRecognizers.add(pageExpiredExceptionRecognizer);
        if (this.inIsisSession()) {
            this.getServicesInjector().streamServices(ExceptionRecognizer.class).forEach(exceptionRecognizers::add);
        } else {
            MetaModelInvalidException mmie = IsisContext.getMetaModelInvalidExceptionIfAny();
            if (mmie != null) {
                Set validationErrors = mmie.getValidationErrors();
                return new MmvErrorPage(validationErrors);
            }
            LOG.warn("Unable to obtain exceptionRecognizers (no session), will be treated as unrecognized exception", (Throwable)ex);
        }
        String recognizedMessageIfAny = new ExceptionRecognizerComposite((List)exceptionRecognizers).recognize((Throwable)ex);
        ExceptionModel exceptionModel = ExceptionModel.create((String)recognizedMessageIfAny, (Exception)ex);
        return this.isSignedIn() ? new ErrorPage(exceptionModel) : this.newSignInPage(exceptionModel);
    }

    private IRequestablePage newSignInPage(ExceptionModel exceptionModel) {
        Page signInPage;
        Class signInPageClass = null;
        if (this.pageClassRegistry != null) {
            signInPageClass = this.pageClassRegistry.getPageClass(PageType.SIGN_IN);
        }
        if (signInPageClass == null) {
            signInPageClass = WicketSignInPage.class;
        }
        PageParameters parameters = new PageParameters();
        try {
            Constructor constructor = signInPageClass.getConstructor(PageParameters.class, ExceptionModel.class);
            signInPage = (Page)constructor.newInstance(parameters, exceptionModel);
        }
        catch (Exception ex) {
            try {
                IPageFactory pageFactory = Application.get().getPageFactory();
                signInPage = (Page)pageFactory.newPage(signInPageClass, parameters);
            }
            catch (Exception x) {
                throw new WicketRuntimeException("Cannot instantiate the configured sign in page", (Throwable)x);
            }
        }
        return signInPage;
    }

    protected boolean isSignedIn() {
        if (!this.inIsisSession()) {
            return false;
        }
        if (this.getAuthenticationSession() == null) {
            return false;
        }
        return this.getWicketAuthenticationSession().isSignedIn();
    }

    public void setPageClassRegistry(PageClassRegistry pageClassRegistry) {
        this.pageClassRegistry = pageClassRegistry;
    }

    protected ServicesInjector getServicesInjector() {
        return this.getIsisSessionFactory().getServicesInjector();
    }

    protected IsisTransactionManager getTransactionManager() {
        return this.getIsisSessionFactory().getCurrentSession().getPersistenceSession().getTransactionManager();
    }

    protected boolean inIsisSession() {
        return this.getIsisSessionFactory().inSession();
    }

    protected AuthenticationSession getAuthenticationSession() {
        return this.getIsisSessionFactory().getCurrentSession().getAuthenticationSession();
    }

    protected MessageBroker getMessageBroker() {
        return this.getAuthenticationSession().getMessageBroker();
    }

    IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }

    TranslationService getTranslationService() {
        return this.getServicesInjector().lookupService(TranslationService.class).orElse(null);
    }

    protected AuthenticatedWebSession getWicketAuthenticationSession() {
        return AuthenticatedWebSession.get();
    }
}

