/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.util;

import org.apache.isis.commons.internal.base._With;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.concurrency.ConcurrencyChecking;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.runtime.persistence.ObjectNotFoundException;
import org.apache.isis.core.runtime.persistence.PojoRecreationException;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.server.util.UrlDecoderUtils;

public final class OidUtils {
    private OidUtils() {
    }

    public static ObjectAdapter getObjectAdapterElseNull(RendererContext rendererContext, String domainType, String instanceIdEncoded) {
        String instanceIdUnencoded = UrlDecoderUtils.urlDecode(instanceIdEncoded);
        String oidStrUnencoded = Oid.marshaller().joinAsOid(domainType, instanceIdUnencoded);
        return OidUtils.getObjectAdapter(rendererContext, oidStrUnencoded);
    }

    public static ObjectAdapter getObjectAdapterElseNull(RendererContext rendererContext, String oidStrEncoded) {
        String oidStrUnencoded = UrlDecoderUtils.urlDecode(oidStrEncoded);
        return OidUtils.getObjectAdapter(rendererContext, oidStrUnencoded);
    }

    private static ObjectAdapter getObjectAdapter(RendererContext rendererContext, String oidStrUnencoded) {
        RootOid rootOid = RootOid.deString((String)oidStrUnencoded);
        PersistenceSession ps = rendererContext.getPersistenceSession();
        Object domainObject = OidUtils.domainObjectForAny(ps, rootOid);
        return ps.adapterFor(domainObject);
    }

    private static Object domainObjectForAny(PersistenceSession persistenceSession, RootOid rootOid) {
        ObjectSpecId specId = rootOid.getObjectSpecId();
        ObjectSpecification spec = persistenceSession.getServicesInjector().getSpecificationLoader().lookupBySpecId(specId);
        if (spec == null) {
            return null;
        }
        if (spec.containsFacet(ViewModelFacet.class)) {
            try {
                RootOid fixedRootOid = OidUtils.ensureConsistentOidState(rootOid);
                ObjectAdapter adapter = persistenceSession.adapterFor(fixedRootOid, ConcurrencyChecking.NO_CHECK);
                Object pojo = _With.mapIfPresentElse((Object)adapter, ManagedObject::getPojo, null);
                return pojo;
            }
            catch (ObjectNotFoundException | PojoRecreationException ex) {
                return null;
            }
        }
        try {
            Object domainObject = persistenceSession.fetchPersistentPojoInTransaction(rootOid);
            return persistenceSession.isTransient(domainObject) ? null : domainObject;
        }
        catch (ObjectNotFoundException ex) {
            return null;
        }
    }

    private static RootOid ensureConsistentOidState(RootOid rootOid) {
        if (!rootOid.isViewModel()) {
            return Oid.Factory.viewmodelOf((ObjectSpecId)rootOid.getObjectSpecId(), (String)rootOid.getIdentifier());
        }
        return rootOid;
    }
}

