/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;

public enum SerializationStrategy {
    XML{

        @Override
        public Object entity(Object jaxbAnnotatedObject) {
            return jaxbAnnotatedObject;
        }

        @Override
        public MediaType type(RepresentationType representationType) {
            return representationType.getXmlMediaType();
        }
    }
    ,
    JSON{

        @Override
        public Object entity(Object jaxbAnnotatedObject) {
            JaxbAnnotationModule jaxbAnnotationModule = new JaxbAnnotationModule();
            ObjectMapper objectMapper = new ObjectMapper().disable(SerializationFeature.WRITE_NULL_MAP_VALUES).disable(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS);
            objectMapper.registerModule((Module)jaxbAnnotationModule);
            try {
                String gridJson = objectMapper.writer().writeValueAsString(jaxbAnnotatedObject);
                return gridJson;
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public MediaType type(RepresentationType representationType) {
            return representationType.getJsonMediaType();
        }
    };


    public abstract Object entity(Object var1);

    public abstract MediaType type(RepresentationType var1);

    public static SerializationStrategy determineFrom(List<MediaType> acceptableMediaTypes) {
        for (MediaType acceptableMediaType : acceptableMediaTypes) {
            if (acceptableMediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
                return JSON;
            }
            if (!acceptableMediaType.isCompatible(MediaType.APPLICATION_XML_TYPE)) continue;
            return XML;
        }
        return JSON;
    }
}

