/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources;

import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.applib.user.UserResource;
import org.apache.isis.viewer.restfulobjects.rendering.Caching;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.Responses;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.isis.viewer.restfulobjects.server.resources.HomePageReprRenderer;
import org.apache.isis.viewer.restfulobjects.server.resources.ResourceAbstract;
import org.apache.isis.viewer.restfulobjects.server.resources.UserReprRenderer;

public class UserResourceServerside
extends ResourceAbstract
implements UserResource {
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/user"})
    public Response user() {
        this.init(RepresentationType.USER, Where.NOWHERE, RepresentationService.Intent.NOT_APPLICABLE);
        UserReprRenderer renderer = new UserReprRenderer(this.getResourceContext(), null, JsonRepresentation.newMap((String[])new String[0]));
        ((UserReprRenderer)renderer.includesSelf()).with(this.getAuthenticationSession());
        return Responses.ofOk((ReprRenderer)renderer, (Caching)Caching.ONE_HOUR).build();
    }

    public Response deleteUserNotAllowed() {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting the user resource is not allowed.", (Object[])new Object[0]);
    }

    public Response putUserNotAllowed() {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Putting to the user resource is not allowed.", (Object[])new Object[0]);
    }

    public Response postUserNotAllowed() {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Posting to the user resource is not allowed.", (Object[])new Object[0]);
    }

    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/homepage"})
    public Response logout() {
        this.init(RepresentationType.HOME_PAGE, Where.NOWHERE, RepresentationService.Intent.NOT_APPLICABLE);
        HomePageReprRenderer renderer = new HomePageReprRenderer(this.getResourceContext(), null, JsonRepresentation.newMap((String[])new String[0]));
        renderer.includesSelf();
        AuthenticationSession authenticationSession = this.getResourceContext().getAuthenticationSession();
        this.getAuthenticationManager().closeSession(authenticationSession);
        this.getIsisSessionFactory().closeSession();
        try {
            URI location = new URI("?__isis_force_logout");
            return Response.temporaryRedirect((URI)location).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

