/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources;

import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.commons.url.UrlDecoderUtil;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.apache.isis.core.security.authentication.manager.AuthenticationManager;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.isis.viewer.restfulobjects.rendering.util.Util;
import org.apache.isis.viewer.restfulobjects.server.ResourceContext;
import org.apache.isis.viewer.restfulobjects.server.util.OidUtils;
import org.apache.isis.viewer.restfulobjects.server.util.UrlDecoderUtils;

public abstract class ResourceAbstract {
    @Context
    HttpHeaders httpHeaders;
    @Context
    UriInfo uriInfo;
    @Context
    Request request;
    @Context
    HttpServletRequest httpServletRequest;
    @Context
    HttpServletResponse httpServletResponse;
    @Context
    SecurityContext securityContext;
    @Context
    Providers providers;
    private ResourceContext resourceContext;

    protected void init(Where where, RepresentationService.Intent intent) {
        this.init(RepresentationType.GENERIC, where, intent);
    }

    protected void init(RepresentationType representationType, Where where, RepresentationService.Intent intent) {
        String queryStringIfAny = this.getUrlDecodedQueryStringIfAny();
        this.init(representationType, where, intent, queryStringIfAny);
    }

    private String getUrlDecodedQueryStringIfAny() {
        String queryStringIfAny = this.httpServletRequest.getQueryString();
        return UrlDecoderUtil.urlDecodeNullSafe((String)queryStringIfAny);
    }

    protected void init(RepresentationType representationType, Where where, RepresentationService.Intent intent, InputStream arguments) {
        String urlDecodedQueryString = Util.asStringUtf8((InputStream)arguments);
        this.init(representationType, where, intent, urlDecodedQueryString);
    }

    protected void init(RepresentationType representationType, Where where, RepresentationService.Intent intent, String urlUnencodedQueryString) {
        if (!this.getIsisSessionFactory().inSession()) {
            throw RestfulObjectsApplicationException.create((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.UNAUTHORIZED);
        }
        if (this.getAuthenticationSession() == null) {
            throw RestfulObjectsApplicationException.create((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.UNAUTHORIZED);
        }
        this.resourceContext = new ResourceContext(representationType, this.httpHeaders, this.providers, this.uriInfo, this.request, where, intent, urlUnencodedQueryString, this.httpServletRequest, this.httpServletResponse, this.securityContext, InteractionInitiatedBy.USER);
    }

    protected ResourceContext getResourceContext() {
        return this.resourceContext;
    }

    protected void setCommandExecutor(Command.Executor executor) {
        ((CommandContext)this.getServicesInjector().lookupServiceElseFail(CommandContext.class)).getCommand().internal().setExecutor(executor);
    }

    protected ObjectAdapter getObjectAdapterElseThrowNotFound(String domainType, String instanceId) {
        ObjectAdapter objectAdapter = this.getObjectAdapterElseNull(domainType, instanceId);
        if (objectAdapter == null) {
            String instanceIdUnencoded = UrlDecoderUtils.urlDecode(instanceId);
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.NOT_FOUND, (String)"could not determine adapter for OID: '%s:%s'", (Object[])new Object[]{domainType, instanceIdUnencoded});
        }
        return objectAdapter;
    }

    protected ObjectAdapter getObjectAdapterElseNull(String domainType, String instanceId) {
        return OidUtils.getObjectAdapterElseNull(this.resourceContext, domainType, instanceId);
    }

    protected ObjectAdapter getServiceAdapter(String serviceId) {
        ObjectAdapter serviceAdapter = this.getPersistenceSession().lookupService(serviceId);
        if (serviceAdapter != null) {
            return serviceAdapter;
        }
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.NOT_FOUND, (String)"Could not locate service '%s'", (Object[])new Object[]{serviceId});
    }

    protected IsisConfiguration getConfiguration() {
        return this.getIsisSessionFactory().getConfiguration();
    }

    protected ServicesInjector getServicesInjector() {
        return this.getIsisSessionFactory().getServicesInjector();
    }

    protected AuthenticationSession getAuthenticationSession() {
        return this.getIsisSessionFactory().getCurrentSession().getAuthenticationSession();
    }

    protected AuthenticationManager getAuthenticationManager() {
        return this.getIsisSessionFactory().getAuthenticationManager();
    }

    protected SpecificationLoader getSpecificationLoader() {
        return this.getIsisSessionFactory().getSpecificationLoader();
    }

    protected PersistenceSession getPersistenceSession() {
        return this.getIsisSessionFactory().getCurrentSession().getPersistenceSession();
    }

    protected IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }

    protected HttpServletRequest getServletRequest() {
        return this.getResourceContext().getHttpServletRequest();
    }
}

