/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources;

import java.util.stream.Stream;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.server.ResourceContext;
import org.apache.isis.viewer.restfulobjects.server.resources.JsonParserHelper;

public class ObjectAdapterUpdateHelper {
    private final ObjectAdapter objectAdapter;
    private final ResourceContext resourceContext;

    public ObjectAdapterUpdateHelper(ResourceContext resourceContext, ObjectAdapter objectAdapter) {
        this.objectAdapter = objectAdapter;
        this.resourceContext = resourceContext;
    }

    boolean copyOverProperties(JsonRepresentation propertiesMap, Intent intent) {
        ObjectSpecification objectSpec = this.objectAdapter.getSpecification();
        Stream<ObjectAssociation> properties = objectSpec.streamAssociations(Contributed.EXCLUDED).filter(ObjectAssociation.Predicates.PROPERTIES);
        boolean[] allOk = new boolean[]{true};
        properties.forEach(association -> {
            allOk[0] = allOk[0] & this.copyOverProperty((ObjectAssociation)association, propertiesMap, intent);
        });
        return allOk[0];
    }

    private boolean copyOverProperty(ObjectAssociation association, JsonRepresentation propertiesMap, Intent intent) {
        ObjectAdapter valueAdapter;
        boolean valueProvided;
        boolean allOk = true;
        OneToOneAssociation property = (OneToOneAssociation)association;
        ObjectSpecification propertySpec = property.getSpecification();
        String id = property.getId();
        JsonRepresentation propertyRepr = propertiesMap.getRepresentation(id, new Object[0]);
        Consent visibility = property.isVisible((ManagedObject)this.objectAdapter, this.resourceContext.getInteractionInitiatedBy(), this.resourceContext.getWhere());
        Consent usability = property.isUsable((ManagedObject)this.objectAdapter, this.resourceContext.getInteractionInitiatedBy(), this.resourceContext.getWhere());
        boolean invisible = visibility.isVetoed();
        boolean disabled = usability.isVetoed();
        boolean bl = valueProvided = propertyRepr != null;
        if (!valueProvided) {
            if (intent.shouldValidate() && (invisible || disabled)) {
                return allOk;
            }
            if (!property.isMandatory()) {
                return allOk;
            }
            String invalidReason = propertiesMap.getString("x-ro-invalidReason");
            if (invalidReason != null) {
                propertiesMap.mapPut("x-ro-invalidReason", invalidReason + "; " + property.getName());
            } else {
                propertiesMap.mapPut("x-ro-invalidReason", "Mandatory field(s) missing: " + property.getName());
            }
            allOk = false;
            return allOk;
        }
        if (intent.shouldValidate()) {
            if (invisible) {
                return allOk;
            }
            if (disabled) {
                propertyRepr.mapPut("invalidReason", usability.getReason());
                allOk = false;
                return allOk;
            }
        }
        try {
            valueAdapter = new JsonParserHelper(this.resourceContext, propertySpec).objectAdapterFor(propertyRepr);
        }
        catch (IllegalArgumentException ex) {
            propertyRepr.mapPut("invalidReason", ex.getMessage());
            allOk = false;
            return allOk;
        }
        Consent validity = property.isAssociationValid((ManagedObject)this.objectAdapter, (ManagedObject)valueAdapter, InteractionInitiatedBy.USER);
        if (validity.isAllowed()) {
            try {
                property.set(this.objectAdapter, valueAdapter, this.resourceContext.getInteractionInitiatedBy());
            }
            catch (IllegalArgumentException ex) {
                propertyRepr.mapPut("invalidReason", ex.getMessage());
                allOk = false;
            }
        } else {
            propertyRepr.mapPut("invalidReason", validity.getReason());
            allOk = false;
        }
        return allOk;
    }

    static enum Intent {
        UPDATE_EXISTING,
        PERSISTING_NEW;


        private boolean shouldValidate() {
            return this == UPDATE_EXISTING;
        }
    }
}

