/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.layout.component.ActionLayoutData;
import org.apache.isis.applib.layout.component.CollectionLayoutData;
import org.apache.isis.applib.layout.component.DomainObjectLayoutData;
import org.apache.isis.applib.layout.component.PropertyLayoutData;
import org.apache.isis.applib.layout.grid.Grid;
import org.apache.isis.applib.layout.links.Link;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.commons.internal.base._Bytes;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.resources._Resources;
import org.apache.isis.core.commons.url.UrlDecoderUtil;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facets.object.grid.GridFacet;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.RestfulHttpMethod;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.DomainObjectResource;
import org.apache.isis.viewer.restfulobjects.rendering.Responses;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.MemberReprMode;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.isis.viewer.restfulobjects.rendering.util.Util;
import org.apache.isis.viewer.restfulobjects.server.resources.DomainResourceHelper;
import org.apache.isis.viewer.restfulobjects.server.resources.JsonParserHelper;
import org.apache.isis.viewer.restfulobjects.server.resources.ObjectAdapterAccessHelper;
import org.apache.isis.viewer.restfulobjects.server.resources.ObjectAdapterUpdateHelper;
import org.apache.isis.viewer.restfulobjects.server.resources.ResourceAbstract;
import org.apache.isis.viewer.restfulobjects.server.resources.serialization.SerializationStrategy;
import org.apache.log4j.Logger;

@Path(value="/objects")
public class DomainObjectResourceServerside
extends ResourceAbstract
implements DomainObjectResource {
    private static final Logger LOG = Logger.getLogger(DomainObjectResourceServerside.class);

    public DomainObjectResourceServerside() {
        LOG.debug((Object)"<init>");
    }

    @POST
    @Path(value="/{domainType}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response persist(@PathParam(value="domainType") String domainType, InputStream object) {
        this.init(RepresentationType.DOMAIN_OBJECT, Where.OBJECT_FORMS, RepresentationService.Intent.JUST_CREATED);
        String objectStr = Util.asStringUtf8((InputStream)object);
        JsonRepresentation objectRepr = Util.readAsMap((String)objectStr);
        if (!objectRepr.isMap()) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (String)"Body is not a map; got %s", (Object[])new Object[]{objectRepr});
        }
        ObjectSpecification domainTypeSpec = this.getSpecificationLoader().lookupBySpecId(ObjectSpecId.of((String)domainType));
        if (domainTypeSpec == null) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (String)"Could not determine type of domain object to persist (no class with domainType Id of '%s')", (Object[])new Object[]{domainType});
        }
        ObjectAdapter objectAdapter = this.getResourceContext().getPersistenceSession().newTransientInstance(domainTypeSpec);
        ObjectAdapterUpdateHelper updateHelper = new ObjectAdapterUpdateHelper(this.getResourceContext(), objectAdapter);
        JsonRepresentation membersMap = objectRepr.getMap("members");
        if (membersMap == null) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (String)"Could not find members map; got %s", (Object[])new Object[]{objectRepr});
        }
        if (!updateHelper.copyOverProperties(membersMap, ObjectAdapterUpdateHelper.Intent.PERSISTING_NEW)) {
            throw RestfulObjectsApplicationException.createWithBody((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (JsonRepresentation)objectRepr, (String)"Illegal property value", (Object[])new Object[0]);
        }
        Consent validity = objectAdapter.getSpecification().isValid((ManagedObject)objectAdapter, InteractionInitiatedBy.USER);
        if (validity.isVetoed()) {
            throw RestfulObjectsApplicationException.createWithBody((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (JsonRepresentation)objectRepr, (String)validity.getReason(), (Object[])new Object[0]);
        }
        this.getResourceContext().getPersistenceSession().makePersistentInTransaction(objectAdapter);
        return this.newDomainResourceHelper(objectAdapter).objectRepresentation(RepresentationService.Intent.JUST_CREATED);
    }

    @GET
    @Path(value="/{domainType}/{instanceId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response object(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId) {
        this.init(RepresentationType.DOMAIN_OBJECT, Where.OBJECT_FORMS, RepresentationService.Intent.ALREADY_PERSISTENT);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        return this.newDomainResourceHelper(objectAdapter).objectRepresentation();
    }

    @PUT
    @Path(value="/{domainType}/{instanceId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response object(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, InputStream object) {
        this.init(RepresentationType.DOMAIN_OBJECT, Where.OBJECT_FORMS, RepresentationService.Intent.ALREADY_PERSISTENT);
        String objectStr = Util.asStringUtf8((InputStream)object);
        JsonRepresentation argRepr = Util.readAsMap((String)objectStr);
        if (!argRepr.isMap()) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (String)"Body is not a map; got %s", (Object[])new Object[]{argRepr});
        }
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        ObjectAdapterUpdateHelper updateHelper = new ObjectAdapterUpdateHelper(this.getResourceContext(), objectAdapter);
        if (!updateHelper.copyOverProperties(argRepr, ObjectAdapterUpdateHelper.Intent.UPDATE_EXISTING)) {
            throw RestfulObjectsApplicationException.createWithBody((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (JsonRepresentation)argRepr, (String)"Illegal property value", (Object[])new Object[0]);
        }
        Consent validity = objectAdapter.getSpecification().isValid((ManagedObject)objectAdapter, InteractionInitiatedBy.USER);
        if (validity.isVetoed()) {
            throw RestfulObjectsApplicationException.createWithBody((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (JsonRepresentation)argRepr, (String)validity.getReason(), (Object[])new Object[0]);
        }
        return this.newDomainResourceHelper(objectAdapter).objectRepresentation();
    }

    public Response deleteMethodNotSupported(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId) {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting objects is not supported.", (Object[])new Object[0]);
    }

    public Response postMethodNotAllowed(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId) {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Posting to object resource is not allowed.", (Object[])new Object[0]);
    }

    @GET
    @Path(value="/{domainType}/{instanceId}/image")
    @Consumes(value={"*/*"})
    @Produces(value={"image/png"})
    public Response image(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId) {
        this.init(RepresentationType.OBJECT_LAYOUT, Where.ANYWHERE, RepresentationService.Intent.NOT_APPLICABLE);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        ObjectSpecification objectSpec = objectAdapter.getSpecification();
        String iconName = objectSpec.getIconName((ManagedObject)objectAdapter);
        Class correspondingClass = objectSpec.getCorrespondingClass();
        IconKey iconKey = new IconKey(correspondingClass, iconName);
        byte[] bytes = iconKey.toBytes();
        return bytes != null ? Response.ok((Object)bytes).build() : Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{domainType}/{instanceId}/object-layout")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-layout-bs3", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-layout-bs3"})
    public Response layout(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId) {
        Response.ResponseBuilder builder;
        this.init(RepresentationType.OBJECT_LAYOUT, Where.ANYWHERE, RepresentationService.Intent.NOT_APPLICABLE);
        List<MediaType> acceptableMediaTypes = this.getResourceContext().getAcceptableMediaTypes();
        SerializationStrategy serializationStrategy = acceptableMediaTypes.contains(MediaType.APPLICATION_XML_TYPE) || acceptableMediaTypes.contains(RepresentationType.OBJECT_LAYOUT.getXmlMediaType()) ? SerializationStrategy.XML : SerializationStrategy.JSON;
        ObjectSpecification objectSpec = this.getSpecificationLoader().lookupBySpecId(ObjectSpecId.of((String)domainType));
        GridFacet gridFacet = (GridFacet)objectSpec.getFacet(GridFacet.class);
        if (gridFacet == null) {
            builder = Responses.ofNotFound();
        } else {
            ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
            Grid grid = gridFacet.getGrid((ManagedObject)objectAdapter);
            this.addLinks(domainType, instanceId, grid);
            builder = Response.status((Response.Status)Response.Status.OK).entity(serializationStrategy.entity(grid)).type(serializationStrategy.type(RepresentationType.OBJECT_LAYOUT));
        }
        return builder.build();
    }

    private void addLinks(final String domainType, final String instanceId, Grid grid) {
        grid.visit((Grid.Visitor)new Grid.VisitorAdapter(){

            public void visit(DomainObjectLayoutData domainObjectLayoutData) {
                Link link = new Link(Rel.ELEMENT.getName(), RestfulHttpMethod.GET.getJavaxRsMethod(), DomainObjectResourceServerside.this.getResourceContext().urlFor("objects/" + domainType + "/" + instanceId), RepresentationType.DOMAIN_OBJECT.getJsonMediaType().toString());
                domainObjectLayoutData.setLink(link);
            }

            public void visit(ActionLayoutData actionLayoutData) {
                Link link = new Link(Rel.ACTION.getName(), RestfulHttpMethod.GET.getJavaxRsMethod(), DomainObjectResourceServerside.this.getResourceContext().urlFor("objects/" + domainType + "/" + instanceId + "/actions/" + actionLayoutData.getId()), RepresentationType.OBJECT_ACTION.getJsonMediaType().toString());
                actionLayoutData.setLink(link);
            }

            public void visit(PropertyLayoutData propertyLayoutData) {
                Link link = new Link(Rel.PROPERTY.getName(), RestfulHttpMethod.GET.getJavaxRsMethod(), DomainObjectResourceServerside.this.getResourceContext().urlFor("objects/" + domainType + "/" + instanceId + "/properties/" + propertyLayoutData.getId()), RepresentationType.OBJECT_PROPERTY.getJsonMediaType().toString());
                propertyLayoutData.setLink(link);
            }

            public void visit(CollectionLayoutData collectionLayoutData) {
                Link link = new Link(Rel.COLLECTION.getName(), RestfulHttpMethod.GET.getJavaxRsMethod(), DomainObjectResourceServerside.this.getResourceContext().urlFor("objects/" + domainType + "/" + instanceId + "/collections/" + collectionLayoutData.getId()), RepresentationType.OBJECT_COLLECTION.getJsonMediaType().toString());
                collectionLayoutData.setLink(link);
            }
        });
    }

    @GET
    @Path(value="/{domainType}/{instanceId}/properties/{propertyId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-property", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-property", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response propertyDetails(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="propertyId") String propertyId) {
        this.init(RepresentationType.OBJECT_PROPERTY, Where.OBJECT_FORMS, RepresentationService.Intent.NOT_APPLICABLE);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        DomainResourceHelper helper = this.newDomainResourceHelper(objectAdapter);
        return helper.propertyDetails(propertyId, MemberReprMode.READ);
    }

    @PUT
    @Path(value="/{domainType}/{instanceId}/properties/{propertyId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-property", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-property", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response modifyProperty(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="propertyId") String propertyId, InputStream body) {
        this.init(Where.OBJECT_FORMS, RepresentationService.Intent.NOT_APPLICABLE);
        this.setCommandExecutor(Command.Executor.USER);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        DomainResourceHelper helper = this.newDomainResourceHelper(objectAdapter);
        ObjectAdapterAccessHelper accessHelper = new ObjectAdapterAccessHelper(this.getResourceContext(), objectAdapter);
        OneToOneAssociation property = accessHelper.getPropertyThatIsVisibleForIntent(propertyId, ObjectAdapterAccessHelper.Intent.MUTATE);
        ObjectSpecification propertySpec = property.getSpecification();
        String bodyAsString = Util.asStringUtf8((InputStream)body);
        ObjectAdapter argAdapter = new JsonParserHelper(this.getResourceContext(), propertySpec).parseAsMapWithSingleValue(bodyAsString);
        Consent consent = property.isAssociationValid((ManagedObject)objectAdapter, (ManagedObject)argAdapter, InteractionInitiatedBy.USER);
        if (consent.isVetoed()) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.UNAUTHORIZED, (String)consent.getReason(), (Object[])new Object[0]);
        }
        property.set(objectAdapter, argAdapter, InteractionInitiatedBy.USER);
        return helper.propertyDetails(propertyId, MemberReprMode.WRITE);
    }

    @DELETE
    @Path(value="/{domainType}/{instanceId}/properties/{propertyId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-property", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-property", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response clearProperty(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="propertyId") String propertyId) {
        this.init(Where.OBJECT_FORMS, RepresentationService.Intent.NOT_APPLICABLE);
        this.setCommandExecutor(Command.Executor.USER);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        DomainResourceHelper helper = this.newDomainResourceHelper(objectAdapter);
        ObjectAdapterAccessHelper accessHelper = new ObjectAdapterAccessHelper(this.getResourceContext(), objectAdapter);
        OneToOneAssociation property = accessHelper.getPropertyThatIsVisibleForIntent(propertyId, ObjectAdapterAccessHelper.Intent.MUTATE);
        Consent consent = property.isAssociationValid((ManagedObject)objectAdapter, null, InteractionInitiatedBy.USER);
        if (consent.isVetoed()) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.UNAUTHORIZED, (String)consent.getReason(), (Object[])new Object[0]);
        }
        property.set(objectAdapter, null, InteractionInitiatedBy.USER);
        return helper.propertyDetails(propertyId, MemberReprMode.WRITE);
    }

    public Response postPropertyNotAllowed(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="propertyId") String propertyId) {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Posting to a property resource is not allowed.", (Object[])new Object[0]);
    }

    @GET
    @Path(value="/{domainType}/{instanceId}/collections/{collectionId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-collection", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-collection", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response accessCollection(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="collectionId") String collectionId) {
        this.init(RepresentationType.OBJECT_COLLECTION, Where.PARENTED_TABLES, RepresentationService.Intent.NOT_APPLICABLE);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        return this.newDomainResourceHelper(objectAdapter).collectionDetails(collectionId, MemberReprMode.READ);
    }

    @PUT
    @Path(value="/{domainType}/{instanceId}/collections/{collectionId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-collection", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-collection", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response addToSet(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="collectionId") String collectionId, InputStream body) {
        this.init(Where.PARENTED_TABLES, RepresentationService.Intent.NOT_APPLICABLE);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        DomainResourceHelper helper = this.newDomainResourceHelper(objectAdapter);
        ObjectAdapterAccessHelper accessHelper = new ObjectAdapterAccessHelper(this.getResourceContext(), objectAdapter);
        OneToManyAssociation collection = accessHelper.getCollectionThatIsVisibleForIntent(collectionId, ObjectAdapterAccessHelper.Intent.MUTATE);
        if (!collection.getCollectionSemantics().isAnySet()) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (String)"Collection '%s' does not have set semantics", (Object[])new Object[]{collectionId});
        }
        ObjectSpecification collectionSpec = collection.getSpecification();
        String bodyAsString = Util.asStringUtf8((InputStream)body);
        ObjectAdapter argAdapter = new JsonParserHelper(this.getResourceContext(), collectionSpec).parseAsMapWithSingleValue(bodyAsString);
        Consent consent = collection.isValidToAdd(objectAdapter, argAdapter, InteractionInitiatedBy.USER);
        if (consent.isVetoed()) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.UNAUTHORIZED, (String)consent.getReason(), (Object[])new Object[0]);
        }
        collection.addElement(objectAdapter, argAdapter, InteractionInitiatedBy.USER);
        return helper.collectionDetails(collectionId, MemberReprMode.WRITE);
    }

    @POST
    @Path(value="/{domainType}/{instanceId}/collections/{collectionId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-collection", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-collection", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response addToList(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="collectionId") String collectionId, InputStream body) {
        this.init(Where.PARENTED_TABLES, RepresentationService.Intent.NOT_APPLICABLE);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        DomainResourceHelper helper = this.newDomainResourceHelper(objectAdapter);
        ObjectAdapterAccessHelper accessHelper = new ObjectAdapterAccessHelper(this.getResourceContext(), objectAdapter);
        OneToManyAssociation collection = accessHelper.getCollectionThatIsVisibleForIntent(collectionId, ObjectAdapterAccessHelper.Intent.MUTATE);
        if (!collection.getCollectionSemantics().isListOrArray()) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Collection '%s' does not have list or array semantics", (Object[])new Object[]{collectionId});
        }
        ObjectSpecification collectionSpec = collection.getSpecification();
        String bodyAsString = Util.asStringUtf8((InputStream)body);
        ObjectAdapter argAdapter = new JsonParserHelper(this.getResourceContext(), collectionSpec).parseAsMapWithSingleValue(bodyAsString);
        Consent consent = collection.isValidToAdd(objectAdapter, argAdapter, InteractionInitiatedBy.USER);
        if (consent.isVetoed()) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.UNAUTHORIZED, (String)consent.getReason(), (Object[])new Object[0]);
        }
        collection.addElement(objectAdapter, argAdapter, InteractionInitiatedBy.USER);
        return helper.collectionDetails(collectionId, MemberReprMode.WRITE);
    }

    @DELETE
    @Path(value="/{domainType}/{instanceId}/collections/{collectionId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-collection", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-collection", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response removeFromCollection(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="collectionId") String collectionId) {
        this.init(Where.PARENTED_TABLES, RepresentationService.Intent.NOT_APPLICABLE);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        DomainResourceHelper helper = this.newDomainResourceHelper(objectAdapter);
        ObjectAdapterAccessHelper accessHelper = new ObjectAdapterAccessHelper(this.getResourceContext(), objectAdapter);
        OneToManyAssociation collection = accessHelper.getCollectionThatIsVisibleForIntent(collectionId, ObjectAdapterAccessHelper.Intent.MUTATE);
        ObjectSpecification collectionSpec = collection.getSpecification();
        ObjectAdapter argAdapter = new JsonParserHelper(this.getResourceContext(), collectionSpec).parseAsMapWithSingleValue(this.getResourceContext().getUrlUnencodedQueryString());
        Consent consent = collection.isValidToRemove(objectAdapter, argAdapter, InteractionInitiatedBy.USER);
        if (consent.isVetoed()) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.UNAUTHORIZED, (String)consent.getReason(), (Object[])new Object[0]);
        }
        collection.removeElement(objectAdapter, argAdapter, InteractionInitiatedBy.USER);
        return helper.collectionDetails(collectionId, MemberReprMode.WRITE);
    }

    @GET
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-action", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-action", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response actionPrompt(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="actionId") String actionId) {
        this.init(RepresentationType.OBJECT_ACTION, Where.OBJECT_FORMS, RepresentationService.Intent.NOT_APPLICABLE);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        DomainResourceHelper helper = this.newDomainResourceHelper(objectAdapter);
        return helper.actionPrompt(actionId);
    }

    public Response deleteActionPromptNotAllowed(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="actionId") String actionId) {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting action prompt resource is not allowed.", (Object[])new Object[0]);
    }

    public Response postActionPromptNotAllowed(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="actionId") String actionId) {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Posting to an action prompt resource is not allowed.", (Object[])new Object[0]);
    }

    public Response putActionPromptNotAllowed(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="actionId") String actionId) {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Putting to an action prompt resource is not allowed.", (Object[])new Object[0]);
    }

    @GET
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/action-result", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/action-result", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response invokeActionQueryOnly(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="actionId") String actionId, @QueryParam(value="x-isis-querystring") String xIsisUrlEncodedQueryString) {
        String urlUnencodedQueryString = UrlDecoderUtil.urlDecodeNullSafe((String)(xIsisUrlEncodedQueryString != null ? xIsisUrlEncodedQueryString : this.httpServletRequest.getQueryString()));
        this.init(RepresentationType.ACTION_RESULT, Where.STANDALONE_TABLES, RepresentationService.Intent.NOT_APPLICABLE, urlUnencodedQueryString);
        this.setCommandExecutor(Command.Executor.USER);
        JsonRepresentation arguments = this.getResourceContext().getQueryStringAsJsonRepr();
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        DomainResourceHelper helper = this.newDomainResourceHelper(objectAdapter);
        return helper.invokeActionQueryOnly(actionId, arguments);
    }

    @PUT
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/action-result", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/action-result", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response invokeActionIdempotent(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="actionId") String actionId, InputStream body) {
        this.init(RepresentationType.ACTION_RESULT, Where.STANDALONE_TABLES, RepresentationService.Intent.NOT_APPLICABLE, body);
        this.setCommandExecutor(Command.Executor.USER);
        JsonRepresentation arguments = this.getResourceContext().getQueryStringAsJsonRepr();
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        DomainResourceHelper helper = this.newDomainResourceHelper(objectAdapter);
        return helper.invokeActionIdempotent(actionId, arguments);
    }

    @POST
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/action-result", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/action-result", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response invokeAction(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="actionId") String actionId, InputStream body) {
        this.init(RepresentationType.ACTION_RESULT, Where.STANDALONE_TABLES, RepresentationService.Intent.NOT_APPLICABLE, body);
        this.setCommandExecutor(Command.Executor.USER);
        JsonRepresentation arguments = this.getResourceContext().getQueryStringAsJsonRepr();
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        DomainResourceHelper helper = this.newDomainResourceHelper(objectAdapter);
        return helper.invokeAction(actionId, arguments);
    }

    public Response deleteInvokeActionNotAllowed(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="actionId") String actionId) {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting an action invocation resource is not allowed.", (Object[])new Object[0]);
    }

    private DomainResourceHelper newDomainResourceHelper(ObjectAdapter objectAdapter) {
        return new DomainResourceHelper(this.getResourceContext(), objectAdapter);
    }

    static class IconKey {
        private final Class<?> domainClass;
        private final String modifier;

        IconKey(Class<?> domainClass, String modifier) {
            this.domainClass = domainClass;
            this.modifier = modifier;
        }

        String getImageName() {
            StringBuilder buf = new StringBuilder(this.domainClass.getSimpleName());
            if (!_Strings.isNullOrEmpty((CharSequence)this.modifier)) {
                buf.append("-").append(this.modifier);
            }
            buf.append(".png");
            return buf.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IconKey iconKey = (IconKey)o;
            if (this.domainClass != null ? !this.domainClass.equals(iconKey.domainClass) : iconKey.domainClass != null) {
                return false;
            }
            return this.modifier != null ? this.modifier.equals(iconKey.modifier) : iconKey.modifier == null;
        }

        public int hashCode() {
            int result = this.domainClass != null ? this.domainClass.hashCode() : 0;
            result = 31 * result + (this.modifier != null ? this.modifier.hashCode() : 0);
            return result;
        }

        byte[] toBytes() {
            String imageName = this.getImageName();
            try {
                InputStream resource = _Resources.load(this.domainClass, (String)imageName);
                return _Bytes.of((InputStream)resource);
            }
            catch (IOException e) {
                return null;
            }
        }
    }
}

