/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.mappers;

import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.system.transaction.IsisTransaction;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.viewer.restfulobjects.server.mappers.ExceptionMapperAbstract;

@Provider
public class ExceptionMapperForRuntimeException
extends ExceptionMapperAbstract<RuntimeException> {
    public Response toResponse(RuntimeException ex) {
        Throwable rootCause = _Exceptions.getRootCause((Throwable)ex);
        List causalChain = _Exceptions.getCausalChain((Throwable)ex);
        for (Throwable throwable : causalChain) {
            if (throwable != rootCause) continue;
            this.getCurrentTransaction().ifPresent(IsisTransaction::clearAbortCause);
        }
        return this.buildResponse(ex);
    }

    private Optional<IsisTransaction> getCurrentTransaction() {
        return this.getCurrentSession().map(IsisSession::getPersistenceSession).map(PersistenceSession::getTransactionManager).map(IsisTransactionManager::getCurrentTransaction);
    }

    private Optional<IsisSession> getCurrentSession() {
        return this.getIsisSessionFactory().map(IsisSessionFactory::getCurrentSession);
    }

    private Optional<IsisSessionFactory> getIsisSessionFactory() {
        try {
            return Optional.ofNullable(IsisContext.getSessionFactory());
        }
        catch (Throwable e) {
            return Optional.empty();
        }
    }
}

