/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.authentication;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.apache.isis.core.security.authentication.standard.SimpleSession;
import org.apache.isis.core.webapp.auth.AuthenticationSessionStrategyAbstract;

public class AuthenticationSessionStrategyHeader
extends AuthenticationSessionStrategyAbstract {
    public static final String HEADER_ISIS_USER = "isis.user";

    public AuthenticationSession lookupValid(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String user = httpServletRequest.getHeader(HEADER_ISIS_USER);
        List<String> roles = this.rolesFrom(httpServletRequest);
        if (_Strings.isNullOrEmpty((CharSequence)user)) {
            return null;
        }
        return new SimpleSession(user, roles);
    }

    protected List<String> rolesFrom(HttpServletRequest httpServletRequest) {
        String rolesStr = httpServletRequest.getHeader("isis.roles");
        if (rolesStr == null) {
            return Collections.emptyList();
        }
        return _Strings.splitThenStream((String)rolesStr, (String)",").collect(Collectors.toList());
    }
}

