/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.service.acceptheader;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.RequestScoped;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.acceptheader.AcceptHeaderService;
import org.apache.isis.commons.internal.base._NullSafe;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
@RequestScoped
public class AcceptHeaderServiceForRest
implements AcceptHeaderService {
    private static ThreadLocal<List<MediaType>> mediaTypesByThread = new ThreadLocal();

    private static void setMediaTypes(List<MediaType> mediaTypes) {
        mediaTypesByThread.set(mediaTypes);
    }

    private static void removeMediaTypes() {
        mediaTypesByThread.remove();
    }

    @Programmatic
    public List<MediaType> getAcceptableMediaTypes() {
        return mediaTypesByThread.get();
    }

    @Provider
    public static class ResponseFilter
    implements ContainerResponseFilter {
        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            AcceptHeaderServiceForRest.removeMediaTypes();
        }
    }

    @Provider
    public static class RequestFilter
    implements ContainerRequestFilter {
        public void filter(ContainerRequestContext requestContext) throws IOException {
            List acceptableMediaTypes = requestContext.getAcceptableMediaTypes();
            List mediaTypes = _NullSafe.stream((Collection)acceptableMediaTypes).filter(_NullSafe::isPresent).collect(Collectors.toList());
            AcceptHeaderServiceForRest.setMediaTypes(mediaTypes);
        }
    }
}

