/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.service;

import java.util.List;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ActionResultReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.MemberReprMode;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndAction;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndActionInvocation;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndCollection;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndProperty;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.isis.viewer.restfulobjects.rendering.service.conneg.ContentNegotiationService;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class RepresentationServiceContentNegotiator
implements RepresentationService {
    @Inject
    List<ContentNegotiationService> contentNegotiationServices;

    @PostConstruct
    public void init() {
    }

    @Override
    @Programmatic
    public Response objectRepresentation(final RepresentationService.Context renderContext, final ObjectAdapter objectAdapter) {
        Response.ResponseBuilder responseBuilder = this.buildResponse(new Function<ContentNegotiationService, Response.ResponseBuilder>(){

            @Override
            public Response.ResponseBuilder apply(ContentNegotiationService connegService) {
                return connegService.buildResponse(renderContext, objectAdapter);
            }
        });
        this.assertContentNegotiationServiceHandled(responseBuilder);
        return this.buildResponse(responseBuilder);
    }

    @Override
    @Deprecated
    @Programmatic
    public Response objectRepresentation(RepresentationService.Context renderContext, ObjectAdapter objectAdapter, RepresentationService.Intent unused) {
        return this.objectRepresentation(renderContext, objectAdapter);
    }

    @Override
    @Programmatic
    public Response propertyDetails(final RepresentationService.Context renderContext, final ObjectAndProperty objectAndProperty, MemberReprMode memberReprMode) {
        Response.ResponseBuilder responseBuilder = this.buildResponse(new Function<ContentNegotiationService, Response.ResponseBuilder>(){

            @Override
            public Response.ResponseBuilder apply(ContentNegotiationService connegService) {
                return connegService.buildResponse(renderContext, objectAndProperty);
            }
        });
        this.assertContentNegotiationServiceHandled(responseBuilder);
        return this.buildResponse(responseBuilder);
    }

    @Override
    @Programmatic
    public Response collectionDetails(final RepresentationService.Context renderContext, final ObjectAndCollection objectAndCollection, MemberReprMode memberReprMode) {
        Response.ResponseBuilder responseBuilder = this.buildResponse(new Function<ContentNegotiationService, Response.ResponseBuilder>(){

            @Override
            public Response.ResponseBuilder apply(ContentNegotiationService connegService) {
                return connegService.buildResponse(renderContext, objectAndCollection);
            }
        });
        this.assertContentNegotiationServiceHandled(responseBuilder);
        return this.buildResponse(responseBuilder);
    }

    @Override
    @Programmatic
    public Response actionPrompt(final RepresentationService.Context renderContext, final ObjectAndAction objectAndAction) {
        Response.ResponseBuilder responseBuilder = this.buildResponse(new Function<ContentNegotiationService, Response.ResponseBuilder>(){

            @Override
            public Response.ResponseBuilder apply(ContentNegotiationService connegService) {
                return connegService.buildResponse(renderContext, objectAndAction);
            }
        });
        this.assertContentNegotiationServiceHandled(responseBuilder);
        return this.buildResponse(responseBuilder);
    }

    @Override
    @Programmatic
    public Response actionResult(final RepresentationService.Context renderContext, final ObjectAndActionInvocation objectAndActionInvocation, ActionResultReprRenderer.SelfLink selfLink) {
        Response.ResponseBuilder responseBuilder = this.buildResponse(new Function<ContentNegotiationService, Response.ResponseBuilder>(){

            @Override
            public Response.ResponseBuilder apply(ContentNegotiationService connegService) {
                return connegService.buildResponse(renderContext, objectAndActionInvocation);
            }
        });
        this.assertContentNegotiationServiceHandled(responseBuilder);
        return this.buildResponse(responseBuilder);
    }

    void assertContentNegotiationServiceHandled(Response.ResponseBuilder responseBuilder) {
        if (responseBuilder == null) {
            throw new IllegalStateException("Could not locate " + ContentNegotiationService.class.getSimpleName() + " to handle request");
        }
    }

    Response.ResponseBuilder buildResponse(Function<ContentNegotiationService, Response.ResponseBuilder> connegServiceBuildResponse) {
        for (ContentNegotiationService contentNegotiationService : this.contentNegotiationServices) {
            Response.ResponseBuilder responseBuilder = connegServiceBuildResponse.apply(contentNegotiationService);
            if (responseBuilder == null) continue;
            return responseBuilder;
        }
        return null;
    }

    protected Response buildResponse(Response.ResponseBuilder responseBuilder) {
        return responseBuilder.build();
    }
}

