/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domaintypes;

import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRendererAbstract;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.MemberType;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.AbstractTypeFeatureReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.DomainTypeReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.ParentSpecAndFeature;

public abstract class AbstractTypeMemberReprRenderer<R extends ReprRendererAbstract<R, ParentSpecAndFeature<T>>, T extends ObjectMember>
extends AbstractTypeFeatureReprRenderer<R, T> {
    protected MemberType memberType;

    public AbstractTypeMemberReprRenderer(RendererContext resourceContext, LinkFollowSpecs linkFollower, RepresentationType representationType, JsonRepresentation representation) {
        super(resourceContext, linkFollower, representationType, representation);
    }

    public MemberType getMemberType() {
        return this.memberType;
    }

    @Override
    public R with(ParentSpecAndFeature<T> specAndFeature) {
        super.with(specAndFeature);
        this.memberType = MemberType.determineFrom(this.objectFeature);
        this.representation.mapPut("id", ((ObjectMember)this.objectFeature).getId());
        this.representation.mapPut("memberType", this.memberType.getName());
        return AbstractTypeMemberReprRenderer.cast(this);
    }

    @Override
    protected void addLinkUpToParent() {
        LinkBuilder parentLinkBuilder = DomainTypeReprRenderer.newLinkToBuilder(this.rendererContext, Rel.UP, this.objectSpecification);
        this.getLinks().arrayAdd(parentLinkBuilder.build());
    }

    @Override
    protected void addLinkSelfIfRequired() {
        if (!this.includesSelf) {
            return;
        }
        ObjectMember objectMember = (ObjectMember)this.getObjectFeature();
        LinkBuilder linkBuilder = LinkBuilder.newBuilder(this.getRendererContext(), Rel.SELF.getName(), this.getMediaType(), "domain-types/%s/%s%s", this.getParentSpecification().getSpecId().asString(), this.getMemberType().getUrlPart(), objectMember.getId());
        this.getLinks().arrayAdd(linkBuilder.build());
    }
}

