/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering;

import javax.ws.rs.core.MediaType;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.RestfulHttpMethod;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;

public final class LinkBuilder {
    private final RendererContext resourceContext;
    private final JsonRepresentation representation = JsonRepresentation.newMap((String[])new String[0]);
    private final String rel;
    private final String href;
    private final MediaType mediaType;
    private RestfulHttpMethod method = RestfulHttpMethod.GET;
    private String title;
    private JsonRepresentation arguments;
    private JsonRepresentation value;

    public static LinkBuilder newBuilder(RendererContext resourceContext, String rel, RepresentationType representationType, String hrefFormat, Object ... hrefArgs) {
        return LinkBuilder.newBuilder(resourceContext, rel, representationType.getJsonElseXmlMediaType(), hrefFormat, hrefArgs);
    }

    public static LinkBuilder newBuilder(RendererContext resourceContext, String rel, MediaType mediaType, String hrefFormat, Object ... hrefArgs) {
        return new LinkBuilder(resourceContext, rel, String.format(hrefFormat, hrefArgs), mediaType);
    }

    protected LinkBuilder(RendererContext resourceContext, String rel, String href, MediaType mediaType) {
        this.resourceContext = resourceContext;
        this.rel = rel;
        this.href = href;
        this.mediaType = mediaType;
    }

    public LinkBuilder withHttpMethod(RestfulHttpMethod method) {
        this.method = method;
        return this;
    }

    public LinkBuilder withTitle(String title) {
        this.title = title;
        return this;
    }

    public LinkBuilder withArguments(JsonRepresentation arguments) {
        this.arguments = arguments;
        return this;
    }

    public LinkBuilder withValue(JsonRepresentation value) {
        this.value = value;
        return this;
    }

    public JsonRepresentation build() {
        this.representation.mapPut("rel", this.rel);
        this.representation.mapPut("href", this.resourceContext.urlFor(this.href));
        this.representation.mapPut("method", (Object)this.method);
        this.representation.mapPut("type", this.mediaType.toString());
        this.representation.mapPut("title", this.title);
        this.representation.mapPut("arguments", this.arguments);
        this.representation.mapPut("value", this.value);
        return this.representation;
    }
}

