/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.schema.utils.jaxbadapters;

import java.util.function.Function;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

class XmlCalendarFactory {
    XmlCalendarFactory() {
    }

    public static XMLGregorianCalendar create(DateTime dateTime) {
        return dateTime != null ? XmlCalendarFactory.withTypeFactoryDo(dtf -> dtf.newXMLGregorianCalendar(dateTime.toGregorianCalendar())) : null;
    }

    public static XMLGregorianCalendar create(LocalDateTime localDateTime) {
        return localDateTime != null ? XmlCalendarFactory.withTypeFactoryDo(dtf -> dtf.newXMLGregorianCalendar(localDateTime.getYear(), localDateTime.getMonthOfYear(), localDateTime.getDayOfMonth(), localDateTime.getHourOfDay(), localDateTime.getMinuteOfHour(), localDateTime.getSecondOfMinute(), localDateTime.getMillisOfSecond(), Integer.MIN_VALUE)) : null;
    }

    public static XMLGregorianCalendar create(LocalDate localDate) {
        return localDate != null ? XmlCalendarFactory.withTypeFactoryDo(dtf -> dtf.newXMLGregorianCalendarDate(localDate.getYear(), localDate.getMonthOfYear(), localDate.getDayOfMonth(), Integer.MIN_VALUE)) : null;
    }

    public static XMLGregorianCalendar create(LocalTime localTime) {
        return localTime != null ? XmlCalendarFactory.withTypeFactoryDo(dtf -> dtf.newXMLGregorianCalendarTime(localTime.getHourOfDay(), localTime.getMinuteOfHour(), localTime.getSecondOfMinute(), localTime.getMillisOfSecond(), Integer.MIN_VALUE)) : null;
    }

    private static XMLGregorianCalendar withTypeFactoryDo(Function<DatatypeFactory, XMLGregorianCalendar> factory) {
        DatatypeFactory dataTypeFactory;
        try {
            dataTypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            System.err.println("Within " + XmlCalendarFactory.class.getName() + ": Exception in call to DatatypeFactory.newInstance()" + e);
            return null;
        }
        return factory.apply(dataTypeFactory);
    }
}

