/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.schema.utils.jaxbadapters;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.isis.schema.utils.jaxbadapters.XmlCalendarFactory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public final class JodaDateTimeXMLGregorianCalendarAdapter {
    private JodaDateTimeXMLGregorianCalendarAdapter() {
    }

    public static DateTime parse(XMLGregorianCalendar xgc) {
        if (xgc == null) {
            return null;
        }
        GregorianCalendar gc = xgc.toGregorianCalendar();
        Date time = gc.getTime();
        TimeZone timeZone = gc.getTimeZone();
        DateTimeZone dateTimeZone = DateTimeZone.forTimeZone((TimeZone)timeZone);
        return new DateTime((Object)time, dateTimeZone);
    }

    public static XMLGregorianCalendar print(DateTime dateTime) {
        return XmlCalendarFactory.create(dateTime);
    }

    public static class ForJaxb
    extends XmlAdapter<XMLGregorianCalendar, DateTime> {
        public DateTime unmarshal(XMLGregorianCalendar dateTimeStr) throws Exception {
            return JodaDateTimeXMLGregorianCalendarAdapter.parse(dateTimeStr);
        }

        public XMLGregorianCalendar marshal(DateTime DateTime2) throws Exception {
            return JodaDateTimeXMLGregorianCalendarAdapter.print(DateTime2);
        }
    }
}

