/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.metamodel;

import java.text.MessageFormat;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;
import org.apache.isis.objectstore.jdo.metamodel.util.JdoPrimaryKeyPropertyPredicate;

public final class JdoPropertyUtils {
    private JdoPropertyUtils() {
    }

    public static OneToOneAssociation getPrimaryKeyPropertyFor(ObjectSpecification objectSpec) {
        return JdoPropertyUtils.getPropertyFor(objectSpec, "@PrimaryKey", (Predicate<ObjectAssociation>)new JdoPrimaryKeyPropertyPredicate());
    }

    public static boolean hasPrimaryKeyProperty(ObjectSpecification objectSpec) {
        return JdoPropertyUtils.getPrimaryKeyPropertyFor(objectSpec) != null;
    }

    private static OneToOneAssociation getPropertyFor(ObjectSpecification objSpec, String annotationName, Predicate<ObjectAssociation> predicate) {
        if (objSpec == null || !objSpec.containsFacet(JdoPersistenceCapableFacet.class)) {
            return null;
        }
        List propertyList = objSpec.streamAssociations(Contributed.EXCLUDED).filter(predicate).limit(2L).collect(Collectors.toList());
        if (propertyList.size() == 0) {
            return JdoPropertyUtils.getPropertyFor(objSpec.superclass(), annotationName, predicate);
        }
        if (propertyList.size() > 1) {
            throw new IllegalStateException(MessageFormat.format("Shouldn''t have more than one property annotated with {0} (''{1}'')", annotationName, objSpec.getFullIdentifier()));
        }
        return (OneToOneAssociation)propertyList.get(0);
    }
}

