/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.webapp.modules;

import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.core.webapp.modules.WebModule;
import org.apache.isis.core.webapp.modules.WebModuleContext;

final class WebModule_Wicket
implements WebModule {
    private static final String WICKET_FILTER_CLASS_NAME = "org.apache.wicket.protocol.http.WicketFilter";
    private static final String WICKET_FILTER_NAME = "WicketFilter";
    private String pathConfigValue;
    private String deploymentMode;
    private String appConfigValue;

    WebModule_Wicket() {
    }

    @Override
    public String getName() {
        return "Wicket";
    }

    @Override
    public void prepare(WebModuleContext ctx) {
        if (!WebModule_Wicket.isAvailable()) {
            return;
        }
        this.pathConfigValue = ctx.getConfiguration().getString("isis.viewer.wicket.basePath", "/wicket");
        this.deploymentMode = _Context.isPrototyping() ? "development" : "deployment";
        this.appConfigValue = ctx.getConfiguration().getString("isis.viewer.wicket.app", "org.apache.isis.viewer.wicket.viewer.IsisWicketApplication");
        ctx.setHasBootstrapper();
        ctx.addViewer("wicket");
        ctx.addProtectedPath(_Strings.suffix((String)_Strings.prefix((String)this.pathConfigValue, (String)"/"), (String)"/") + "*");
    }

    @Override
    public ServletContextListener init(ServletContext ctx) throws ServletException {
        Filter filter;
        try {
            Class<?> filterClass = _Context.getDefaultClassLoader().loadClass(WICKET_FILTER_CLASS_NAME);
            filter = ctx.createFilter((Class)_Casts.uncheckedCast(filterClass));
        }
        catch (ClassNotFoundException e) {
            throw _Exceptions.unexpectedCodeReach();
        }
        FilterRegistration.Dynamic reg = ctx.addFilter(WICKET_FILTER_NAME, filter);
        if (reg == null) {
            return null;
        }
        String urlPattern = this.getUrlPattern();
        reg.setInitParameter("applicationClassName", this.getApplicationClassName());
        reg.setInitParameter("filterMappingUrlPattern", urlPattern);
        reg.setInitParameter("configuration", this.getWicketMode());
        reg.addMappingForUrlPatterns(null, true, new String[]{urlPattern});
        return null;
    }

    @Override
    public boolean isApplicable(WebModuleContext ctx) {
        return WebModule_Wicket.isAvailable();
    }

    private static boolean isAvailable() {
        try {
            _Context.getDefaultClassLoader().loadClass(WICKET_FILTER_CLASS_NAME);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getUrlPattern() {
        String wicketPath = this.getWicketPath();
        String wicketPathEnclosedWithSlashes = _Strings.suffix((String)_Strings.prefix((String)wicketPath, (String)"/"), (String)"/");
        String urlPattern = wicketPathEnclosedWithSlashes + "*";
        return urlPattern;
    }

    private String getWicketPath() {
        return Objects.requireNonNull(this.pathConfigValue, "This web-module needs to be prepared first.");
    }

    private String getWicketMode() {
        return Objects.requireNonNull(this.deploymentMode, "This web-module needs to be prepared first.");
    }

    private String getApplicationClassName() {
        return Objects.requireNonNull(this.appConfigValue, "This web-module needs to be prepared first.");
    }
}

