/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.webapp.modules;

import java.util.Objects;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.commons.internal.resources._Resources;
import org.apache.isis.core.webapp.IsisSessionFilter;
import org.apache.isis.core.webapp.modules.WebModule;
import org.apache.isis.core.webapp.modules.WebModuleContext;

final class WebModule_RestEasy
implements WebModule {
    public static final String KEY_RESTFUL_BASE_PATH = "isis.viewer.restfulobjects.basePath";
    public static final String KEY_RESTFUL_BASE_PATH_DEFAULT = "/restful";
    private static final String RESTEASY_BOOTSTRAPPER = "org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap";
    private static final String RESTEASY_DISPATCHER = "RestfulObjectsRestEasyDispatcher";
    String restfulPathConfigValue;

    WebModule_RestEasy() {
    }

    @Override
    public String getName() {
        return "RestEasy";
    }

    @Override
    public void prepare(WebModuleContext ctx) {
        if (!this.isApplicable(ctx)) {
            return;
        }
        String restfulPath = ctx.getConfiguration().getString(KEY_RESTFUL_BASE_PATH, KEY_RESTFUL_BASE_PATH_DEFAULT);
        _Resources.putRestfulPath((String)restfulPath);
        this.restfulPathConfigValue = restfulPath;
        ctx.addViewer("restfulobjects");
        ctx.addProtectedPath(_Strings.suffix((String)_Strings.prefix((String)restfulPath, (String)"/"), (String)"/") + "*");
    }

    @Override
    public ServletContextListener init(ServletContext ctx) throws ServletException {
        FilterRegistration.Dynamic filter = ctx.addFilter("IsisSessionFilterForRestfulObjects", IsisSessionFilter.class);
        filter.addMappingForServletNames(null, true, new String[]{RESTEASY_DISPATCHER});
        filter.setInitParameter("authenticationSessionStrategy", "org.apache.isis.viewer.restfulobjects.server.authentication.AuthenticationSessionStrategyBasicAuth");
        filter.setInitParameter("whenNoSession", "auto");
        filter.setInitParameter("passThru", String.join((CharSequence)",", this.getRestfulPath() + "swagger", this.getRestfulPath() + "health"));
        filter = ctx.addFilter(RESTEASY_DISPATCHER, "org.apache.isis.viewer.restfulobjects.server.webapp.IsisTransactionFilterForRestfulObjects");
        filter.addMappingForServletNames(null, true, new String[]{RESTEASY_DISPATCHER});
        ctx.setInitParameter("javax.ws.rs.Application", "org.apache.isis.viewer.restfulobjects.server.RestfulObjectsApplication");
        ctx.setInitParameter("resteasy.servlet.mapping.prefix", this.getRestfulPath());
        ctx.addServlet(RESTEASY_DISPATCHER, "org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher");
        ctx.getServletRegistration(RESTEASY_DISPATCHER).addMapping(new String[]{this.getUrlPattern()});
        try {
            Class<?> listenerClass = _Context.getDefaultClassLoader().loadClass(RESTEASY_BOOTSTRAPPER);
            return (ServletContextListener)ctx.createListener((Class)_Casts.uncheckedCast(listenerClass));
        }
        catch (ClassNotFoundException e) {
            throw _Exceptions.unexpectedCodeReach();
        }
    }

    @Override
    public boolean isApplicable(WebModuleContext ctx) {
        try {
            _Context.getDefaultClassLoader().loadClass(RESTEASY_BOOTSTRAPPER);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getUrlPattern() {
        return this.getRestfulPath() + "*";
    }

    private String getRestfulPath() {
        Objects.requireNonNull(this.restfulPathConfigValue, "This web-module needs to be prepared first.");
        String restfulPathEnclosedWithSlashes = _Strings.suffix((String)_Strings.prefix((String)this.restfulPathConfigValue, (String)"/"), (String)"/");
        return restfulPathEnclosedWithSlashes;
    }
}

