/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.webapp.modules;

import java.util.stream.Stream;
import javax.servlet.ServletContext;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.config.internal._Config;

public class WebModuleContext {
    private boolean hasBootstrapper = false;
    private final StringBuilder viewers = new StringBuilder();
    private final StringBuilder protectedPath = new StringBuilder();
    private final ServletContext servletContext;
    private final IsisConfiguration isisConfiguration;

    public WebModuleContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.isisConfiguration = _Config.getConfiguration();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public IsisConfiguration getConfiguration() {
        return this.isisConfiguration;
    }

    public void setHasBootstrapper() {
        this.hasBootstrapper = true;
    }

    public boolean hasBootstrapper() {
        return this.hasBootstrapper;
    }

    public void addViewer(String viewerName) {
        if (this.viewers.length() > 0) {
            this.viewers.append(",");
        }
        this.viewers.append(viewerName);
    }

    public void addProtectedPath(String path) {
        if (this.protectedPath.length() > 0) {
            this.protectedPath.append(",");
        }
        this.protectedPath.append(path);
    }

    public Stream<String> streamProtectedPaths() {
        String list = this.protectedPath.toString();
        return _Strings.splitThenStream((String)list, (String)",");
    }
}

