/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.webapp.jee;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;
import org.apache.isis.applib.services.metrics.MetricsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IsisCDIBeanScanInterceptor
implements Extension {
    private static final Logger log = LoggerFactory.getLogger(IsisCDIBeanScanInterceptor.class);
    private static final List<Predicate<Class<?>>> tabu = new ArrayList();

    public IsisCDIBeanScanInterceptor() {
        tabu.add(MetricsService.class::equals);
        tabu.add(ExceptionRecognizer.class::isAssignableFrom);
    }

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event) {
        log.info("beginning the scanning process");
    }

    <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> event) {
        Class clazz = event.getAnnotatedType().getJavaClass();
        String className = clazz.getName();
        if (this.isTabu(clazz, event)) {
            log.debug("veto type: " + className);
            event.veto();
        } else {
            log.debug("allowing type: " + className);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery event) {
        log.info("finished the scanning process");
    }

    private boolean isTabu(Class<?> clazz, ProcessAnnotatedType<?> event) {
        if (event.getAnnotatedType().isAnnotationPresent(DomainService.class)) {
            return true;
        }
        for (Predicate<Class<?>> isTabu : tabu) {
            if (!isTabu.test(clazz)) continue;
            return true;
        }
        return false;
    }
}

