/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.webapp.auth;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.isis.applib.fixtures.LogonFixture;
import org.apache.isis.config.WebAppConstants;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.security.authentication.AuthenticationRequest;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.apache.isis.core.security.authentication.fixtures.AuthenticationRequestLogonFixture;
import org.apache.isis.core.security.authentication.manager.AuthenticationManager;
import org.apache.isis.core.webapp.auth.AuthenticationSessionStrategyAbstract;

public class AuthenticationSessionStrategyDefault
extends AuthenticationSessionStrategyAbstract {
    @Override
    public AuthenticationSession lookupValid(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        boolean loggedInUsingLogonFixture;
        IsisSessionFactory sessionFactory;
        boolean sessionValid;
        AuthenticationManager authenticationManager = this.authenticationManagerFrom(httpServletRequest);
        HttpSession httpSession = this.getHttpSession((ServletRequest)httpServletRequest);
        AuthenticationSession authSession = (AuthenticationSession)httpSession.getAttribute(WebAppConstants.HTTP_SESSION_AUTHENTICATION_SESSION_KEY);
        if (authSession != null && (sessionValid = authenticationManager.isSessionValid(authSession))) {
            return authSession;
        }
        try {
            sessionFactory = IsisContext.getSessionFactory();
        }
        catch (Exception e) {
            return null;
        }
        LogonFixture logonFixture = sessionFactory.getLogonFixture();
        boolean bl = loggedInUsingLogonFixture = httpSession.getAttribute(WebAppConstants.HTTP_SESSION_LOGGED_ON_PREVIOUSLY_USING_LOGON_FIXTURE_KEY) != null;
        if (logonFixture != null && !loggedInUsingLogonFixture) {
            httpSession.setAttribute(WebAppConstants.HTTP_SESSION_LOGGED_ON_PREVIOUSLY_USING_LOGON_FIXTURE_KEY, (Object)true);
            return authenticationManager.authenticate((AuthenticationRequest)new AuthenticationRequestLogonFixture(logonFixture));
        }
        return null;
    }

    @Override
    public void bind(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthenticationSession authSession) {
        HttpSession httpSession = this.getHttpSession((ServletRequest)httpServletRequest);
        if (authSession != null) {
            httpSession.setAttribute(WebAppConstants.HTTP_SESSION_AUTHENTICATION_SESSION_KEY, (Object)authSession);
        } else {
            httpSession.removeAttribute(WebAppConstants.HTTP_SESSION_AUTHENTICATION_SESSION_KEY);
        }
    }
}

