/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.systemusinginstallers;

import java.util.List;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.config.internal._Config;
import org.apache.isis.core.commons.components.ApplicationScopedComponent;
import org.apache.isis.core.commons.components.Installer;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.commons.factory.InstanceCreationClassException;
import org.apache.isis.core.commons.factory.InstanceCreationException;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.commons.factory.UnavailableClassException;
import org.apache.isis.core.commons.lang.ObjectExtensions;
import org.apache.isis.core.security.authentication.manager.AuthenticationManager;
import org.apache.isis.core.security.authentication.manager.AuthenticationManagerInstaller;
import org.apache.isis.core.security.authorization.manager.AuthorizationManager;
import org.apache.isis.core.security.authorization.manager.AuthorizationManagerInstaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IsisComponentProviderHelper_UsingInstallers {
    final AppManifest appManifest;
    final AuthenticationManager authenticationManager;
    final AuthorizationManager authorizationManager;

    IsisComponentProviderHelper_UsingInstallers(AppManifest appManifest) {
        this(appManifest, new InstallerLookup());
    }

    private IsisComponentProviderHelper_UsingInstallers(AppManifest appManifest, InstallerLookup installerLookup) {
        this.appManifest = appManifest;
        this.authenticationManager = IsisComponentProviderHelper_UsingInstallers.lookupAuthenticationManager(appManifest, installerLookup);
        this.authorizationManager = IsisComponentProviderHelper_UsingInstallers.lookupAuthorizationManager(appManifest, installerLookup);
    }

    private static AuthenticationManager lookupAuthenticationManager(AppManifest appManifest, InstallerLookup installerLookup) {
        String authenticationMechanism = appManifest.getAuthenticationMechanism();
        AuthenticationManagerInstaller authenticationInstaller = installerLookup.authenticationManagerInstaller(authenticationMechanism);
        return authenticationInstaller.createAuthenticationManager();
    }

    private static AuthorizationManager lookupAuthorizationManager(AppManifest appManifest, InstallerLookup installerLookup) {
        String authorizationMechanism = appManifest.getAuthorizationMechanism();
        AuthorizationManagerInstaller authorizationInstaller = installerLookup.authorizationManagerInstaller(authorizationMechanism);
        return authorizationInstaller.createAuthorizationManager();
    }

    @Deprecated
    static class InstallerLookup
    implements ApplicationScopedComponent {
        private static final Logger LOG = LoggerFactory.getLogger(InstallerLookup.class);
        private final List<Installer> installerList = _Lists.newArrayList();

        public InstallerLookup() throws InstanceCreationException {
            List installerClassNames = _Lists.of((Object[])new String[]{"org.apache.isis.core.security.authentication.BypassAuthenticationManagerInstaller", "org.apache.isis.security.shiro.authentication.ShiroAuthenticationManagerInstaller", "org.apache.isis.core.security.authorization.BypassAuthorizationManagerInstaller", "org.apache.isis.security.shiro.authorization.ShiroAuthorizationManagerInstaller"});
            for (String className : installerClassNames) {
                if (className.length() == 0 || className.startsWith("#")) continue;
                try {
                    Installer object = (Installer)InstanceUtil.createInstance((String)className, (Object[])new Object[0]);
                    LOG.debug("created component installer: {} - {}", (Object)object.getName(), (Object)className);
                    this.installerList.add(object);
                }
                catch (UnavailableClassException e) {
                    LOG.info("component installer not found; it will not be available: {}", (Object)className);
                }
                catch (InstanceCreationClassException e) {
                    LOG.info("instance creation exception: {}", (Object)e.getMessage());
                }
                catch (InstanceCreationException e) {
                    try {
                        Installer object = (Installer)InstanceUtil.createInstance((String)className, (Object[])new Object[0]);
                        LOG.debug("created component installer: {} - {}", (Object)object.getName(), (Object)className);
                        this.installerList.add(object);
                    }
                    catch (UnavailableClassException e2) {
                        LOG.info("component installer not found; it will not be available: {}", (Object)className);
                    }
                    catch (InstanceCreationClassException e2) {
                        LOG.info("instance creation exception: {}", (Object)e2.getMessage());
                    }
                }
            }
        }

        public AuthenticationManagerInstaller authenticationManagerInstaller(String requested) {
            return this.getInstaller(AuthenticationManagerInstaller.class, requested, "isis.authentication", "shiro");
        }

        public AuthorizationManagerInstaller authorizationManagerInstaller(String requested) {
            return this.getInstaller(AuthorizationManagerInstaller.class, requested, "isis.authorization", "shiro");
        }

        private <T extends Installer> T getInstaller(Class<T> cls, String implName) {
            Assert.assertNotNull((String)"No name specified", (Object)implName);
            for (Installer installer : this.installerList) {
                if (!cls.isAssignableFrom(installer.getClass()) || !installer.getName().equals(implName)) continue;
                return (T)installer;
            }
            return (T)this.getInstaller(implName);
        }

        public Installer getInstaller(String implClassName) {
            try {
                return (Installer)ObjectExtensions.asT((Object)InstanceUtil.createInstance((String)implClassName, (Object[])new Object[0]));
            }
            catch (UnavailableClassException e) {
                return null;
            }
        }

        private <T extends Installer> T getInstaller(Class<T> requiredType, String reqImpl, String key, String defaultImpl) {
            if (reqImpl == null) {
                reqImpl = _Config.peekAtString((String)key, (String)defaultImpl);
            }
            if (reqImpl == null) {
                return null;
            }
            T installer = this.getInstaller(requiredType, reqImpl);
            if (installer == null) {
                throw new InstanceCreationException("Failed to load installer; named/class:'" + reqImpl + "' (of type " + requiredType.getName() + ")");
            }
            return installer;
        }
    }
}

