/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.systemusinginstallers;

import org.apache.isis.applib.AppManifest;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.core.runtime.authorization.standard.AuthorizationManagerStandard;
import org.apache.isis.core.runtime.systemusinginstallers.AuthenticatorBypass;
import org.apache.isis.core.runtime.systemusinginstallers.IsisComponentProvider;
import org.apache.isis.core.security.authentication.manager.AuthenticationManager;
import org.apache.isis.core.security.authentication.standard.AuthenticationManagerStandard;
import org.apache.isis.core.security.authentication.standard.Authenticator;
import org.apache.isis.core.security.authorization.manager.AuthorizationManager;

public class IsisComponentProviderBuilder {
    private AppManifest appManifest;
    private AuthenticationManager authenticationManager;
    private AuthorizationManager authorizationManager;

    public IsisComponentProviderBuilder appManifest(AppManifest appManifest) {
        this.appManifest = appManifest;
        return this;
    }

    public IsisComponentProviderBuilder authenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
        return this;
    }

    public IsisComponentProviderBuilder authorizationManager(AuthorizationManager authorizationManager) {
        this.authorizationManager = authorizationManager;
        return this;
    }

    public IsisComponentProvider build() {
        this.authenticationManager = (AuthenticationManager)_With.computeIfAbsent((Object)this.authenticationManager, IsisComponentProviderBuilder::authenticationManagerWithBypass);
        this.authorizationManager = (AuthorizationManager)_With.computeIfAbsent((Object)this.authorizationManager, AuthorizationManagerStandard::new);
        return new IsisComponentProvider(this.appManifest, this.authenticationManager, this.authorizationManager);
    }

    private static AuthenticationManager authenticationManagerWithBypass() {
        AuthenticationManagerStandard authenticationManager = new AuthenticationManagerStandard();
        authenticationManager.addAuthenticator((Authenticator)new AuthenticatorBypass());
        return authenticationManager;
    }
}

