/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence.adaptermanager;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.object.callbacks.CallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.CreatedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.CreatedLifecycleEventFacet;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.ObjectAdapterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ObjectAdapterContext_ObjectCreation {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectAdapterContext_ObjectCreation.class);
    private final ObjectAdapterContext objectAdapterContext;
    private final PersistenceSession persistenceSession;
    private final ServicesInjector servicesInjector;
    private final SpecificationLoader specificationLoader;

    ObjectAdapterContext_ObjectCreation(ObjectAdapterContext objectAdapterContext, PersistenceSession persistenceSession) {
        this.objectAdapterContext = objectAdapterContext;
        this.persistenceSession = persistenceSession;
        this.servicesInjector = persistenceSession.getServicesInjector();
        this.specificationLoader = this.servicesInjector.getSpecificationLoader();
    }

    public ObjectAdapter newInstance(ObjectSpecification objectSpec) {
        return this.newInstance(objectSpec, Variant.TRANSIENT, null);
    }

    public ObjectAdapter recreateInstance(ObjectSpecification objectSpec, @Nullable String memento) {
        return this.newInstance(objectSpec, Variant.VIEW_MODEL, memento);
    }

    private ObjectAdapter newInstance(ObjectSpecification spec, Variant variant, String memento) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating {} instance of {}", (Object)variant, (Object)spec);
        }
        Object pojo = variant == Variant.VIEW_MODEL ? this.recreateViewModel(spec, memento) : this.objectAdapterContext.instantiateAndInjectServices(spec);
        ObjectAdapter adapter = this.objectAdapterContext.getObjectAdapterProvider().adapterFor(pojo);
        return this.initializePropertiesAndDoCallback(adapter);
    }

    private Object recreateViewModel(ObjectSpecification spec, String memento) {
        Object viewModelPojo;
        ViewModelFacet facet = (ViewModelFacet)spec.getFacet(ViewModelFacet.class);
        if (facet == null) {
            throw new IllegalArgumentException("spec does not have ViewModelFacet; spec is " + spec.getFullIdentifier());
        }
        if (facet.getRecreationMechanism().isInitializes()) {
            viewModelPojo = this.objectAdapterContext.instantiateAndInjectServices(spec);
            facet.initialize(viewModelPojo, memento);
        } else {
            viewModelPojo = facet.instantiate(spec.getCorrespondingClass(), memento);
        }
        return viewModelPojo;
    }

    private ObjectAdapter initializePropertiesAndDoCallback(ObjectAdapter adapter) {
        Stream fields = adapter.getSpecification().streamAssociations(Contributed.EXCLUDED);
        fields.forEach(field -> field.toDefault(adapter));
        Object pojo = adapter.getPojo();
        this.servicesInjector.injectServicesInto(pojo);
        CallbackFacet.Util.callCallback((ManagedObject)adapter, CreatedCallbackFacet.class);
        if (Command.class.isAssignableFrom(pojo.getClass())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping postEvent for creation of Command pojo");
            }
        } else {
            this.objectAdapterContext.postLifecycleEventIfRequired((ManagedObject)adapter, CreatedLifecycleEventFacet.class);
        }
        return adapter;
    }

    private static enum Variant {
        TRANSIENT,
        VIEW_MODEL;

    }
}

