/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence.adaptermanager;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.isis.commons.internal.base._Lazy;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.services.ServiceUtil;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.ObjectAdapterContext;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.ObjectAdapterContext_OidProviders;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.factories.OidFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ObjectAdapterContext_ObjectAdapterProvider
implements ObjectAdapterProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectAdapterContext_ObjectAdapterProvider.class);
    private final ObjectAdapterContext objectAdapterContext;
    private final ServicesInjector servicesInjector;
    private final SpecificationLoader specificationLoader;
    private final OidFactory oidFactory;
    private final _Lazy<Map<String, ObjectAdapter>> serviceAdapters = _Lazy.of(this::initServiceAdapters);

    ObjectAdapterContext_ObjectAdapterProvider(ObjectAdapterContext objectAdapterContext, PersistenceSession persistenceSession) {
        this.objectAdapterContext = objectAdapterContext;
        this.servicesInjector = persistenceSession.getServicesInjector();
        this.specificationLoader = this.servicesInjector.getSpecificationLoader();
        this.oidFactory = OidFactory.builder(pojo -> this.specificationLoader.loadSpecification(pojo.getClass())).add(new ObjectAdapterContext_OidProviders.GuardAgainstRootOid()).add(new ObjectAdapterContext_OidProviders.OidForServices()).add(new ObjectAdapterContext_OidProviders.OidForValues()).add(new ObjectAdapterContext_OidProviders.OidForViewModels()).add(new ObjectAdapterContext_OidProviders.OidForPersistent()).add(new ObjectAdapterContext_OidProviders.OidForOthers()).build();
    }

    public ObjectAdapter adapterFor(Object pojo) {
        if (pojo == null) {
            return null;
        }
        RootOid rootOid = this.oidFactory.oidFor(pojo);
        ObjectAdapter newAdapter = this.objectAdapterContext.getFactories().createRootAdapter(pojo, rootOid);
        return this.objectAdapterContext.injectServices(newAdapter);
    }

    public ObjectAdapter adapterFor(Object pojo, RootOid parentOid, OneToManyAssociation collection) {
        _With.requires((Object)parentOid, (String)"parentOid");
        _With.requires((Object)collection, (String)"collection");
        ObjectAdapter newAdapter = this.objectAdapterContext.getFactories().createCollectionAdapter(pojo, parentOid, collection);
        return this.objectAdapterContext.injectServices(newAdapter);
    }

    public ObjectSpecification specificationForViewModel(Object viewModelPojo) {
        ObjectSpecification objectSpecification = this.specificationLoader.loadSpecification(viewModelPojo.getClass());
        return objectSpecification;
    }

    public ManagedObject disposableAdapterForViewModel(Object viewModelPojo) {
        return ManagedObject.of(() -> this.specificationLoader.loadSpecification(viewModelPojo.getClass()), (Object)viewModelPojo);
    }

    public ObjectAdapter adapterForViewModel(Object viewModelPojo, String mementoString) {
        return this.objectAdapterContext.adapterForViewModel(viewModelPojo, mementoString);
    }

    public ObjectAdapter newTransientInstance(ObjectSpecification objectSpec) {
        return this.objectAdapterContext.objectCreationMixin.newInstance(objectSpec);
    }

    public ObjectAdapter recreateViewModelInstance(ObjectSpecification objectSpec, String memento) {
        return this.objectAdapterContext.objectCreationMixin.recreateInstance(objectSpec, memento);
    }

    public Stream<ObjectAdapter> streamServices() {
        return ((Map)this.serviceAdapters.get()).values().stream();
    }

    public ObjectAdapter lookupService(String serviceId) {
        return (ObjectAdapter)((Map)this.serviceAdapters.get()).get(serviceId);
    }

    private Map<String, ObjectAdapter> initServiceAdapters() {
        return this.servicesInjector.streamServices().map(this::adapterFor).peek(serviceAdapter -> Assert.assertFalse((String)"expected to not be 'transient'", (boolean)serviceAdapter.getOid().isTransient())).collect(Collectors.toMap(ServiceUtil::idOfAdapter, v -> v, (o, n) -> n, LinkedHashMap::new));
    }
}

