/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence.adaptermanager;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.isis.commons.internal.functions._Predicates;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.facets.propcoll.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.properties.update.modify.PropertySetterFacet;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.runtime.memento.CollectionData;
import org.apache.isis.core.runtime.memento.Data;
import org.apache.isis.core.runtime.memento.ObjectData;
import org.apache.isis.core.runtime.memento.StandaloneData;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.ObjectAdapterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ObjectAdapterContext_MementoSupport
implements ObjectAdapterContext.MementoRecreateObjectSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectAdapterContext_MementoSupport.class);
    private final ObjectAdapterContext objectAdapterContext;
    private final PersistenceSession persistenceSession;

    ObjectAdapterContext_MementoSupport(ObjectAdapterContext objectAdapterContext, PersistenceSession persistenceSession) {
        this.objectAdapterContext = objectAdapterContext;
        this.persistenceSession = persistenceSession;
    }

    @Override
    public ObjectAdapter recreateObject(ObjectSpecification spec, Oid oid, Data data) {
        ObjectAdapter adapter;
        if (spec.isParentedOrFreeCollection()) {
            Supplier<Object> emptyCollectionPojoFactory = () -> this.objectAdapterContext.instantiateAndInjectServices(spec);
            Object collectionPojo = this.populateCollection(emptyCollectionPojoFactory, spec, (CollectionData)data);
            adapter = this.objectAdapterContext.recreatePojo(oid, collectionPojo);
        } else {
            Assert.assertTrue((String)"oid must be a RootOid representing an object because spec is not a collection and cannot be a value", (boolean)(oid instanceof RootOid));
            RootOid typedOid = (RootOid)oid;
            adapter = this.persistenceSession.adapterFor(typedOid);
            this.updateObject(adapter, data);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("recreated object {}", (Object)adapter.getOid());
        }
        return adapter;
    }

    private ObjectAdapter recreateReference(Data data) {
        if (data instanceof StandaloneData) {
            StandaloneData standaloneData = (StandaloneData)data;
            return standaloneData.getAdapter();
        }
        Oid oid = data.getOid();
        Assert.assertTrue((String)"can only create a reference to an entity", (boolean)(oid instanceof RootOid));
        RootOid rootOid = (RootOid)oid;
        ObjectAdapter referencedAdapter = this.persistenceSession.adapterFor(rootOid);
        if (data instanceof ObjectData && rootOid.isTransient()) {
            this.updateObject(referencedAdapter, data);
        }
        return referencedAdapter;
    }

    private void updateObject(ObjectAdapter adapter, Data data) {
        Oid oid = adapter.getOid();
        if (oid != null && !oid.equals(data.getOid())) {
            throw new IllegalArgumentException("This memento can only be used to update the ObjectAdapter with the Oid " + data.getOid() + " but is " + oid);
        }
        if (!(data instanceof ObjectData)) {
            throw new IsisException("Expected an ObjectData but got " + data.getClass());
        }
        this.updateFieldsAndResolveState(adapter, data);
        if (LOG.isDebugEnabled()) {
            LOG.debug("object updated {}", (Object)adapter.getOid());
        }
    }

    private Object populateCollection(Supplier<Object> emptyCollectionPojoFactory, ObjectSpecification collectionSpec, CollectionData state) {
        Stream<ObjectAdapter> initData = state.streamElements().map(elementData -> this.recreateReference((Data)elementData));
        CollectionFacet facet = (CollectionFacet)collectionSpec.getFacet(CollectionFacet.class);
        return facet.populatePojo(emptyCollectionPojoFactory, collectionSpec, initData, state.getElementCount());
    }

    private void updateFieldsAndResolveState(ObjectAdapter objectAdapter, Data data) {
        boolean dataIsTransient = data.getOid().isTransient();
        if (!dataIsTransient) {
            this.updateFields(objectAdapter, data);
            objectAdapter.getOid().setVersion(data.getOid().getVersion());
        } else if (objectAdapter.isTransient() && dataIsTransient) {
            this.updateFields(objectAdapter, data);
        } else if (objectAdapter.isParentedCollection()) {
            this.updateFields(objectAdapter, data);
        } else {
            ObjectData od = (ObjectData)data;
            if (od.containsField()) {
                throw new IsisException("Resolve state (for " + objectAdapter + ") inconsistent with fact that data exists for fields");
            }
        }
    }

    private void updateFields(ObjectAdapter object, Data state) {
        ObjectData od = (ObjectData)state;
        Stream fields = object.getSpecification().streamAssociations(Contributed.EXCLUDED);
        fields.filter(field -> {
            if (field.isNotPersisted()) {
                if (field.isOneToManyAssociation()) {
                    return false;
                }
                if (field.containsFacet(PropertyOrCollectionAccessorFacet.class) && !field.containsFacet(PropertySetterFacet.class)) {
                    LOG.debug("ignoring not-settable field {}", (Object)field.getName());
                    return false;
                }
            }
            return true;
        }).forEach(field -> this.updateField(object, od, (ObjectAssociation)field));
    }

    private void updateField(ObjectAdapter objectAdapter, ObjectData objectData, ObjectAssociation objectAssoc) {
        Object fieldData = objectData.getEntry(objectAssoc.getId());
        if (objectAssoc.isOneToManyAssociation()) {
            this.updateOneToManyAssociation(objectAdapter, (OneToManyAssociation)objectAssoc, (CollectionData)fieldData);
        } else if (objectAssoc.getSpecification().containsFacet(EncodableFacet.class)) {
            EncodableFacet facet = (EncodableFacet)objectAssoc.getSpecification().getFacet(EncodableFacet.class);
            ObjectAdapter value = facet.fromEncodedString((String)fieldData);
            ((OneToOneAssociation)objectAssoc).initAssociation(objectAdapter, value);
        } else if (objectAssoc.isOneToOneAssociation()) {
            this.updateOneToOneAssociation(objectAdapter, (OneToOneAssociation)objectAssoc, (Data)fieldData);
        }
    }

    private void updateOneToManyAssociation(ObjectAdapter objectAdapter, OneToManyAssociation otma, CollectionData collectionData) {
        ObjectAdapter collection = otma.get(objectAdapter, InteractionInitiatedBy.FRAMEWORK);
        Set original = CollectionFacet.Utils.streamAdapters((ManagedObject)collection).collect(Collectors.toCollection(LinkedHashSet::new));
        Set incoming = collectionData.streamElements().map(this::recreateReference).collect(Collectors.toCollection(LinkedHashSet::new));
        incoming.stream().filter(original::contains).forEach(elementAdapter -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("  association {} changed, added {}", (Object)otma, (Object)elementAdapter.getOid());
            }
            otma.addElement(objectAdapter, elementAdapter, InteractionInitiatedBy.FRAMEWORK);
        });
        original.stream().filter(_Predicates.not(incoming::contains)).forEach(elementAdapter -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("  association {} changed, removed {}", (Object)otma, (Object)elementAdapter.getOid());
            }
            otma.removeElement(objectAdapter, elementAdapter, InteractionInitiatedBy.FRAMEWORK);
        });
    }

    private void updateOneToOneAssociation(ObjectAdapter objectAdapter, OneToOneAssociation otoa, Data assocData) {
        if (assocData == null) {
            otoa.initAssociation(objectAdapter, null);
        } else {
            ObjectAdapter ref = this.recreateReference(assocData);
            if (otoa.get(objectAdapter, InteractionInitiatedBy.FRAMEWORK) != ref) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  association {} changed to {}", (Object)otoa, (Object)ref.getOid());
                }
                otoa.initAssociation(objectAdapter, ref);
            }
        }
    }
}

