/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence.adaptermanager;

import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.ObjectAdapterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ObjectAdapterContext_DependencyInjection {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectAdapterContext_DependencyInjection.class);
    private final ObjectAdapterContext objectAdapterContext;
    private final PersistenceSession persistenceSession;
    private final ServicesInjector servicesInjector;
    private final SpecificationLoader specificationLoader;

    ObjectAdapterContext_DependencyInjection(ObjectAdapterContext objectAdapterContext, PersistenceSession persistenceSession) {
        this.objectAdapterContext = objectAdapterContext;
        this.persistenceSession = persistenceSession;
        this.servicesInjector = persistenceSession.getServicesInjector();
        this.specificationLoader = this.servicesInjector.getSpecificationLoader();
    }

    Object instantiateAndInjectServices(ObjectSpecification objectSpec) {
        Object newInstance;
        Class correspondingClass = objectSpec.getCorrespondingClass();
        if (correspondingClass.isArray()) {
            return Array.newInstance(correspondingClass.getComponentType(), 0);
        }
        Class cls = correspondingClass;
        if (Modifier.isAbstract(cls.getModifiers())) {
            throw new IsisException("Cannot create an instance of an abstract class: " + cls);
        }
        try {
            newInstance = cls.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IsisException("Failed to create instance of type " + objectSpec.getFullIdentifier(), (Throwable)e);
        }
        this.servicesInjector.injectServicesInto(newInstance);
        return newInstance;
    }
}

